/*
 * Decompiled with CFR 0.152.
 */
package guideme.scene.annotation;

import guideme.color.ColorValue;
import guideme.scene.annotation.InWorldAnnotation;
import java.util.OptionalDouble;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Intersectionf;
import org.joml.Matrix4f;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public final class InWorldLineAnnotation
extends InWorldAnnotation {
    public static final float DEFAULT_THICKNESS = 0.03125f;
    private final Vector3f from;
    private final Vector3f to;
    private final ColorValue color;
    private final float thickness;

    public InWorldLineAnnotation(Vector3f from, Vector3f to, ColorValue color, float thickness) {
        this.from = from;
        this.to = to;
        this.color = color;
        this.thickness = thickness;
    }

    public InWorldLineAnnotation(Vector3f from, Vector3f to, ColorValue color) {
        this(from, to, color, 0.03125f);
    }

    @Override
    public OptionalDouble intersect(Vector3f rayOrigin, Vector3f rayDir) {
        Vector3f rayTo = new Vector3f((Vector3fc)rayOrigin).add((Vector3fc)rayDir);
        Vector3f resultA = new Vector3f();
        Vector3f resultB = new Vector3f();
        float distance = Intersectionf.findClosestPointsLineSegments((float)this.from.x, (float)this.from.y, (float)this.from.z, (float)this.to.x, (float)this.to.y, (float)this.to.z, (float)rayOrigin.x, (float)rayOrigin.y, (float)rayOrigin.z, (float)rayTo.x, (float)rayTo.y, (float)rayTo.z, (Vector3f)resultA, (Vector3f)resultB);
        if (distance > this.thickness * this.thickness / 4.0f) {
            return OptionalDouble.empty();
        }
        float distanceFromOrigin = resultB.sub((Vector3fc)rayOrigin).lengthSquared() / rayDir.lengthSquared();
        return OptionalDouble.of(distanceFromOrigin);
    }

    @Override
    public Pair<Vector2f, Vector2f> getScreenBounds(Matrix4f viewMatrix) {
        Vector3f minScreen = new Vector3f(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY);
        Vector3f maxScreen = new Vector3f(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY);
        Vector3f tmpPos = new Vector3f();
        for (int i = 0; i <= 1; ++i) {
            Vector3f p = i == 0 ? this.from : this.to;
            for (int xCorner = 0; xCorner <= 1; ++xCorner) {
                for (int yCorner = 0; yCorner <= 1; ++yCorner) {
                    for (int zCorner = 0; zCorner <= 1; ++zCorner) {
                        float x = xCorner == 0 ? p.x - this.thickness / 2.0f : p.x + this.thickness / 2.0f;
                        float y = yCorner == 0 ? p.y - this.thickness / 2.0f : p.y + this.thickness / 2.0f;
                        float z = zCorner == 0 ? p.z - this.thickness / 2.0f : p.z + this.thickness / 2.0f;
                        viewMatrix.transformPosition(x, y, z, tmpPos);
                        minScreen.min((Vector3fc)tmpPos);
                        maxScreen.max((Vector3fc)tmpPos);
                    }
                }
            }
        }
        return Pair.of((Object)new Vector2f(minScreen.x, minScreen.y), (Object)new Vector2f(maxScreen.x, maxScreen.y));
    }

    public Vector3f min() {
        return this.from;
    }

    public Vector3f max() {
        return this.to;
    }

    public ColorValue color() {
        return this.color;
    }

    public float thickness() {
        return this.thickness;
    }
}

