/*
 * Decompiled with CFR 0.152.
 */
package guideme.libs.micromark.commonmark;

import guideme.libs.micromark.Assert;
import guideme.libs.micromark.CharUtil;
import guideme.libs.micromark.Construct;
import guideme.libs.micromark.NamedCharacterEntities;
import guideme.libs.micromark.State;
import guideme.libs.micromark.Token;
import guideme.libs.micromark.TokenizeContext;
import guideme.libs.micromark.Tokenizer;
import java.util.function.IntPredicate;

public final class CharacterReference {
    public static final Construct characterReference = new Construct();

    private CharacterReference() {
    }

    static {
        CharacterReference.characterReference.name = "characterReference";
        CharacterReference.characterReference.tokenize = (context, effects, ok, nok) -> new StateMachine(context, effects, ok, nok)::start;
    }

    private static class StateMachine {
        private final TokenizeContext context;
        private final Tokenizer.Effects effects;
        private final State ok;
        private final State nok;
        private int size;
        private int max;
        private RefType type;

        public StateMachine(TokenizeContext context, Tokenizer.Effects effects, State ok, State nok) {
            this.context = context;
            this.effects = effects;
            this.ok = ok;
            this.nok = nok;
        }

        private State start(int code) {
            Assert.check(code == 38, "expected `&`");
            this.effects.enter("characterReference");
            this.effects.enter("characterReferenceMarker");
            this.effects.consume(code);
            this.effects.exit("characterReferenceMarker");
            return this::open;
        }

        private State open(int code) {
            if (code == 35) {
                this.effects.enter("characterReferenceMarkerNumeric");
                this.effects.consume(code);
                this.effects.exit("characterReferenceMarkerNumeric");
                return this::numeric;
            }
            this.effects.enter("characterReferenceValue");
            this.max = 31;
            this.type = RefType.ALPHANUMERIC;
            return this.value(code);
        }

        private State numeric(int code) {
            if (code == 88 || code == 120) {
                this.effects.enter("characterReferenceMarkerHexadecimal");
                this.effects.consume(code);
                this.effects.exit("characterReferenceMarkerHexadecimal");
                this.effects.enter("characterReferenceValue");
                this.max = 6;
                this.type = RefType.HEX_NUMERIC;
                return this::value;
            }
            this.effects.enter("characterReferenceValue");
            this.max = 7;
            this.type = RefType.NUMERIC;
            return this.value(code);
        }

        private State value(int code) {
            if (code == 59 && this.size != 0) {
                Token token = this.effects.exit("characterReferenceValue");
                if (this.type == RefType.ALPHANUMERIC && !NamedCharacterEntities.isNamedReference(this.context.sliceSerialize(token))) {
                    return this.nok.step(code);
                }
                this.effects.enter("characterReferenceMarker");
                this.effects.consume(code);
                this.effects.exit("characterReferenceMarker");
                this.effects.exit("characterReference");
                return this.ok;
            }
            if (this.type.test.test(code) && this.size++ < this.max) {
                this.effects.consume(code);
                return this::value;
            }
            return this.nok.step(code);
        }

        static enum RefType {
            ALPHANUMERIC(CharUtil::asciiAlphanumeric),
            NUMERIC(CharUtil::asciiDigit),
            HEX_NUMERIC(CharUtil::asciiHexDigit);

            public final IntPredicate test;

            private RefType(IntPredicate test) {
                this.test = test;
            }
        }
    }
}

