/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.search.similarities;

import guideme.internal.shaded.lucene.index.FieldInvertState;
import guideme.internal.shaded.lucene.search.CollectionStatistics;
import guideme.internal.shaded.lucene.search.Explanation;
import guideme.internal.shaded.lucene.search.TermStatistics;
import guideme.internal.shaded.lucene.search.similarities.Similarity;
import java.util.ArrayList;

public class MultiSimilarity
extends Similarity {
    protected final Similarity[] sims;

    public MultiSimilarity(Similarity[] sims) {
        this.sims = sims;
    }

    @Override
    public long computeNorm(FieldInvertState state) {
        return this.sims[0].computeNorm(state);
    }

    @Override
    public Similarity.SimScorer scorer(float boost, CollectionStatistics collectionStats, TermStatistics ... termStats) {
        Similarity.SimScorer[] subScorers = new Similarity.SimScorer[this.sims.length];
        for (int i = 0; i < subScorers.length; ++i) {
            subScorers[i] = this.sims[i].scorer(boost, collectionStats, termStats);
        }
        return new MultiSimScorer(subScorers);
    }

    static class MultiSimScorer
    extends Similarity.SimScorer {
        private final Similarity.SimScorer[] subScorers;

        MultiSimScorer(Similarity.SimScorer[] subScorers) {
            this.subScorers = subScorers;
        }

        @Override
        public float score(float freq, long norm) {
            double sum = 0.0;
            for (Similarity.SimScorer subScorer : this.subScorers) {
                sum += (double)subScorer.score(freq, norm);
            }
            return (float)sum;
        }

        @Override
        public Explanation explain(Explanation freq, long norm) {
            ArrayList<Explanation> subs = new ArrayList<Explanation>();
            for (Similarity.SimScorer subScorer : this.subScorers) {
                subs.add(subScorer.explain(freq, norm));
            }
            return Explanation.match((Number)Float.valueOf(this.score(freq.getValue().floatValue(), norm)), "sum of:", subs);
        }
    }
}

