/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.queryparser.xml.builders;

import guideme.internal.shaded.lucene.queryparser.xml.DOMUtils;
import guideme.internal.shaded.lucene.queryparser.xml.ParserException;
import guideme.internal.shaded.lucene.queryparser.xml.QueryBuilder;
import guideme.internal.shaded.lucene.queryparser.xml.QueryBuilderFactory;
import guideme.internal.shaded.lucene.search.BoostQuery;
import guideme.internal.shaded.lucene.search.ConstantScoreQuery;
import guideme.internal.shaded.lucene.search.Query;
import org.w3c.dom.Element;

public class ConstantScoreQueryBuilder
implements QueryBuilder {
    private final QueryBuilderFactory queryFactory;

    public ConstantScoreQueryBuilder(QueryBuilderFactory queryFactory) {
        this.queryFactory = queryFactory;
    }

    @Override
    public Query getQuery(Element e) throws ParserException {
        Element queryElem = DOMUtils.getFirstChildOrFail(e);
        Query q = new ConstantScoreQuery(this.queryFactory.getQuery(queryElem));
        float boost = DOMUtils.getAttribute(e, "boost", 1.0f);
        if (boost != 1.0f) {
            q = new BoostQuery(q, boost);
        }
        return q;
    }
}

