/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.codecs.Codec;
import guideme.internal.shaded.lucene.codecs.StoredFieldsWriter;
import guideme.internal.shaded.lucene.document.StoredValue;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.SegmentInfo;
import guideme.internal.shaded.lucene.index.SegmentWriteState;
import guideme.internal.shaded.lucene.index.Sorter;
import guideme.internal.shaded.lucene.store.Directory;
import guideme.internal.shaded.lucene.store.IOContext;
import guideme.internal.shaded.lucene.util.Accountable;
import guideme.internal.shaded.lucene.util.IOUtils;
import java.io.IOException;

class StoredFieldsConsumer {
    final Codec codec;
    final Directory directory;
    final SegmentInfo info;
    StoredFieldsWriter writer;
    Accountable accountable = Accountable.NULL_ACCOUNTABLE;
    private int lastDoc;

    StoredFieldsConsumer(Codec codec, Directory directory, SegmentInfo info) {
        this.codec = codec;
        this.directory = directory;
        this.info = info;
        this.lastDoc = -1;
    }

    protected void initStoredFieldsWriter() throws IOException {
        if (this.writer == null) {
            this.writer = this.codec.storedFieldsFormat().fieldsWriter(this.directory, this.info, IOContext.DEFAULT);
            this.accountable = this.writer;
        }
    }

    void startDocument(int docID) throws IOException {
        assert (this.lastDoc < docID);
        this.initStoredFieldsWriter();
        while (++this.lastDoc < docID) {
            this.writer.startDocument();
            this.writer.finishDocument();
        }
        this.writer.startDocument();
    }

    void writeField(FieldInfo info, StoredValue value) throws IOException {
        switch (value.getType()) {
            case INTEGER: {
                this.writer.writeField(info, value.getIntValue());
                break;
            }
            case LONG: {
                this.writer.writeField(info, value.getLongValue());
                break;
            }
            case FLOAT: {
                this.writer.writeField(info, value.getFloatValue());
                break;
            }
            case DOUBLE: {
                this.writer.writeField(info, value.getDoubleValue());
                break;
            }
            case BINARY: {
                this.writer.writeField(info, value.getBinaryValue());
                break;
            }
            case STRING: {
                this.writer.writeField(info, value.getStringValue());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    void finishDocument() throws IOException {
        this.writer.finishDocument();
    }

    void finish(int maxDoc) throws IOException {
        while (this.lastDoc < maxDoc - 1) {
            this.startDocument(this.lastDoc);
            this.finishDocument();
            ++this.lastDoc;
        }
    }

    void flush(SegmentWriteState state, Sorter.DocMap sortMap) throws IOException {
        try {
            this.writer.finish(state.segmentInfo.maxDoc());
        }
        catch (Throwable throwable) {
            IOUtils.close(this.writer);
            throw throwable;
        }
        IOUtils.close(this.writer);
    }

    void abort() {
        IOUtils.closeWhileHandlingException(this.writer);
    }
}

