/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.index.BaseCompositeReader;
import guideme.internal.shaded.lucene.index.IndexReader;
import java.io.IOException;
import java.util.Comparator;

public class MultiReader
extends BaseCompositeReader<IndexReader> {
    private final boolean closeSubReaders;

    public MultiReader(IndexReader ... subReaders) throws IOException {
        this(subReaders, null, true);
    }

    public MultiReader(IndexReader[] subReaders, boolean closeSubReaders) throws IOException {
        this(subReaders, null, closeSubReaders);
    }

    public MultiReader(IndexReader[] subReaders, Comparator<IndexReader> subReadersSorter, boolean closeSubReaders) throws IOException {
        super((IndexReader[])subReaders.clone(), subReadersSorter);
        this.closeSubReaders = closeSubReaders;
        if (!closeSubReaders) {
            for (int i = 0; i < subReaders.length; ++i) {
                subReaders[i].incRef();
            }
        }
    }

    @Override
    public IndexReader.CacheHelper getReaderCacheHelper() {
        if (this.getSequentialSubReaders().size() == 1) {
            return ((IndexReader)this.getSequentialSubReaders().get(0)).getReaderCacheHelper();
        }
        return null;
    }

    @Override
    protected synchronized void doClose() throws IOException {
        IOException ioe = null;
        for (IndexReader r : this.getSequentialSubReaders()) {
            try {
                if (this.closeSubReaders) {
                    r.close();
                    continue;
                }
                r.decRef();
            }
            catch (IOException e) {
                if (ioe != null) continue;
                ioe = e;
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }
}

