/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.registry;

import dev.xylonity.bonsai.ghosts.config.GhostsConfig;
import dev.xylonity.bonsai.ghosts.config.SpawnConfig;
import dev.xylonity.bonsai.ghosts.registry.GhostsEntities;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.ModifiableBiomeInfo;

public class GhostsSpawns {
    private static final SpawnConfig GHOST_SPAWN_CONFIG = SpawnConfig.parse(GhostsConfig.GHOST_SPAWN);
    private static final SpawnConfig SMALL_GHOST_SPAWN_CONFIG = SpawnConfig.parse(GhostsConfig.SMALL_GHOST_SPAWN);

    public static void addBiomeSpawns(Holder<Biome> biomeHolder, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        int max;
        int min;
        int weight;
        if (GHOST_SPAWN_CONFIG.matches(biomeHolder)) {
            weight = GhostsSpawns.GHOST_SPAWN_CONFIG.weight;
            min = GhostsSpawns.GHOST_SPAWN_CONFIG.minCount;
            max = GhostsSpawns.GHOST_SPAWN_CONFIG.maxCount;
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData(GhostsEntities.GHOST.get(), weight, min, max));
        }
        if (SMALL_GHOST_SPAWN_CONFIG.matches(biomeHolder)) {
            weight = GhostsSpawns.SMALL_GHOST_SPAWN_CONFIG.weight;
            min = GhostsSpawns.SMALL_GHOST_SPAWN_CONFIG.minCount;
            max = GhostsSpawns.SMALL_GHOST_SPAWN_CONFIG.maxCount;
            builder.getMobSpawnSettings().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData(GhostsEntities.SMALL_GHOST.get(), weight, min, max));
        }
    }
}

