/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.common.entity.ai.generic;

import dev.xylonity.bonsai.ghosts.common.entity.MainGhostEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class GhostWanderGoal
extends Goal {
    protected final MainGhostEntity ghost;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    protected final double speedModifier;
    protected int interval;
    protected boolean forceTrigger;
    private final boolean checkNoActionTime;
    private final float lerp;
    private Vec3 targetPos;

    public GhostWanderGoal(MainGhostEntity ghost, double speedModifier, int interval, boolean checkNoActionTime, float lerpFactor) {
        this.ghost = ghost;
        this.speedModifier = speedModifier;
        this.interval = interval;
        this.checkNoActionTime = checkNoActionTime;
        this.lerp = lerpFactor;
        this.forceTrigger = false;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public GhostWanderGoal(MainGhostEntity ghost, double speedModifier) {
        this(ghost, speedModifier, 120, false, 0.1f);
    }

    public boolean m_8036_() {
        Vec3 pos;
        if (this.ghost.m_21824_() && this.ghost.getMainInteraction() != 2) {
            return false;
        }
        if (this.ghost.m_20160_() || this.ghost.m_21825_()) {
            return false;
        }
        if (!this.forceTrigger) {
            if (this.checkNoActionTime && this.ghost.m_21216_() >= 100) {
                return false;
            }
            if (this.ghost.m_217043_().m_188503_(GhostWanderGoal.m_186073_((int)this.interval)) != 0) {
                return false;
            }
        }
        if ((pos = this.getPosition()) == null) {
            return false;
        }
        this.wantedX = pos.f_82479_;
        this.wantedY = pos.f_82480_;
        this.wantedZ = pos.f_82481_;
        this.forceTrigger = false;
        return true;
    }

    @Nullable
    protected Vec3 getPosition() {
        Vec3 origin = this.ghost.m_20182_();
        RandomSource rand = this.ghost.m_217043_();
        double horizontalRange = 8.0;
        double verticalRange = 4.0;
        for (int attempt = 0; attempt < 12; ++attempt) {
            double dx = (rand.m_188500_() * 2.0 - 1.0) * horizontalRange;
            double dz = (rand.m_188500_() * 2.0 - 1.0) * horizontalRange;
            double dy = (rand.m_188500_() * 2.0 - 1.0) * verticalRange;
            Vec3 c = origin.m_82520_(dx, dy, dz);
            c = new Vec3(c.f_82479_, Mth.m_14008_((double)c.f_82480_, (double)(this.ghost.m_9236_().m_141937_() + 1), (double)(this.ghost.m_9236_().m_151558_() - 1)), c.f_82481_);
            if (!this.isSafePosition(c)) continue;
            return c;
        }
        return null;
    }

    private boolean isSafePosition(Vec3 pos) {
        if (!this.ghost.m_9236_().m_45756_((Entity)this.ghost, this.ghost.m_20191_().m_82386_(pos.f_82479_ - this.ghost.m_20185_(), pos.f_82480_ - this.ghost.m_20186_(), pos.f_82481_ - this.ghost.m_20189_()))) {
            return false;
        }
        BlockPos min = new BlockPos(Mth.m_14107_((double)(pos.f_82479_ - (double)(this.ghost.m_20205_() / 2.0f))), Mth.m_14107_((double)pos.f_82480_), Mth.m_14107_((double)(pos.f_82481_ - (double)(this.ghost.m_20205_() / 2.0f))));
        BlockPos max = new BlockPos(Mth.m_14107_((double)(pos.f_82479_ + (double)(this.ghost.m_20205_() / 2.0f))), Mth.m_14107_((double)(pos.f_82480_ + (double)this.ghost.m_20206_())), Mth.m_14107_((double)(pos.f_82481_ + (double)(this.ghost.m_20205_() / 2.0f))));
        for (BlockPos check : BlockPos.m_121940_((BlockPos)min, (BlockPos)max)) {
            BlockState state = this.ghost.m_9236_().m_8055_(check);
            if (state.m_60795_() || !state.m_60819_().m_76178_()) continue;
            return false;
        }
        return true;
    }

    public void m_8056_() {
        this.targetPos = new Vec3(this.wantedX, this.wantedY, this.wantedZ);
        this.ghost.f_19794_ = true;
    }

    public boolean m_8045_() {
        double dz;
        double dy;
        if (this.ghost.m_21824_() && this.ghost.getMainInteraction() != 2) {
            return false;
        }
        if (this.ghost.m_20160_() || this.ghost.m_21825_() || this.targetPos == null) {
            return false;
        }
        double dx = this.targetPos.f_82479_ - this.ghost.m_20185_();
        return dx * dx + (dy = this.targetPos.f_82480_ - this.ghost.m_20186_()) * dy + (dz = this.targetPos.f_82481_ - this.ghost.m_20189_()) * dz > 1.0;
    }

    public void m_8037_() {
        if (this.targetPos == null) {
            return;
        }
        this.ghost.m_7618_(EntityAnchorArgument.Anchor.EYES, this.targetPos);
        Vec3 delta = this.targetPos.m_82546_(this.ghost.m_20182_());
        Vec3 dir = delta.m_82490_(1.0 / delta.m_82553_());
        Vec3 vel = dir.m_82490_(this.speedModifier);
        Vec3 cur = this.ghost.m_20184_();
        double vx = Mth.m_14139_((double)this.lerp, (double)cur.f_82479_, (double)vel.f_82479_);
        double vy = Mth.m_14139_((double)this.lerp, (double)cur.f_82480_, (double)vel.f_82480_);
        double vz = Mth.m_14139_((double)this.lerp, (double)cur.f_82481_, (double)vel.f_82481_);
        this.ghost.m_20334_(vx, vy, vz);
    }

    public void m_8041_() {
        this.ghost.f_19794_ = false;
        this.targetPos = null;
    }
}

