/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.crab;

import com.faboslav.friendsandfoes.common.entity.CrabEntity;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public final class CrabTravelToBurrowSpotTask
extends Behavior<CrabEntity> {
    private static final int MAX_TRAVELLING_TICKS = 600;
    private static final float WITHING_DISTANCE = 1.5f;

    public CrabTravelToBurrowSpotTask() {
        super(Map.of(FriendsAndFoesMemoryModuleTypes.CRAB_HAS_EGG.get(), MemoryStatus.VALUE_PRESENT, FriendsAndFoesMemoryModuleTypes.CRAB_BURROW_POS.get(), MemoryStatus.VALUE_PRESENT), 600);
    }

    protected boolean shouldRun(ServerLevel world, CrabEntity crab) {
        GlobalPos burrowSpotPos = crab.getBurrowSpotPos();
        return burrowSpotPos != null;
    }

    protected void run(ServerLevel world, CrabEntity crab, long time) {
        this.walkTowardsBurrowSpot(crab);
    }

    protected boolean shouldKeepRunning(ServerLevel world, CrabEntity crab, long time) {
        GlobalPos burrowSpotPos = crab.getBurrowSpotPos();
        return burrowSpotPos != null && crab.isBurrowSpotAccessible(burrowSpotPos.m_122646_());
    }

    protected void keepRunning(ServerLevel world, CrabEntity crab, long time) {
        if (crab.m_21573_().m_26572_()) {
            return;
        }
        this.walkTowardsBurrowSpot(crab);
    }

    protected void finishRunning(ServerLevel world, CrabEntity crab, long time) {
        crab.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        GlobalPos burrowSpotPos = crab.getBurrowSpotPos();
        if (!(burrowSpotPos == null || burrowSpotPos.m_122646_().m_203195_((Position)crab.m_20182_(), 1.5) && crab.isBurrowSpotAccessible(burrowSpotPos.m_122646_()))) {
            crab.setHasEgg(false);
            crab.m_27601_(600);
            crab.m_6274_().m_21936_(FriendsAndFoesMemoryModuleTypes.CRAB_BURROW_POS.get());
        }
    }

    private void walkTowardsBurrowSpot(CrabEntity crab) {
        GlobalPos burrowSpotPos = crab.m_6274_().m_257414_(FriendsAndFoesMemoryModuleTypes.CRAB_BURROW_POS.get()).orElse(null);
        if (burrowSpotPos == null) {
            return;
        }
        BehaviorUtils.m_22617_((LivingEntity)crab, (BlockPos)new BlockPos((Vec3i)burrowSpotPos.m_122646_()), (float)0.6f, (int)0);
    }
}

