/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage.client;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import forestry.api.ForestryConstants;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.joml.Vector3f;

public class FilledCrateModel
implements IUnbakedGeometry<FilledCrateModel> {
    @Nullable
    public static BakedModel cachedBaseModel = null;
    @Nullable
    public static ItemTransforms cachedTransforms = null;
    @Nullable
    public static List<BakedQuad> cachedQuads;
    private final BlockModel contents;

    public FilledCrateModel(BlockModel contents) {
        this.contents = contents;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
        if (cachedBaseModel == null) {
            cachedBaseModel = bakery.m_245361_(Loader.FILLED_CRATE_LOCATION).m_7611_(bakery, spriteGetter, modelState, modelLocation);
            cachedTransforms = cachedBaseModel.m_7442_();
            cachedQuads = cachedBaseModel.m_213637_(null, null, RandomSource.m_216327_());
        }
        return new Baked(this.contents.m_7611_(bakery, spriteGetter, modelState, modelLocation), cachedQuads, cachedTransforms);
    }

    public static BlockElement make2dElement(int layer, float startX, float startY, float endX, float endY, float zOffset) {
        Map<Direction, BlockElementFace> faces = Map.of(Direction.SOUTH, new BlockElementFace(null, layer, "layer" + layer, new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0)), Direction.NORTH, new BlockElementFace(null, layer, "layer" + layer, new BlockFaceUV(new float[]{16.0f, 0.0f, 0.0f, 16.0f}, 0)));
        return new BlockElement(new Vector3f(startX, startY, 7.5f - zOffset), new Vector3f(endX, endY, 8.5f + zOffset), faces, null, false);
    }

    public static class Loader
    implements IGeometryLoader<FilledCrateModel> {
        private static final ResourceLocation FILLED_CRATE_LOCATION = ForestryConstants.forestry("item/filled_crate");

        public FilledCrateModel read(JsonObject json, JsonDeserializationContext ctx) {
            ArrayList<BlockElement> elements = new ArrayList<BlockElement>();
            HashMap<CallSite, Either> textureMap = new HashMap<CallSite, Either>();
            ArrayList<Material> materials = new ArrayList<Material>();
            for (int layer = 1; layer <= 4; ++layer) {
                if (!json.has("textures") || !json.get("textures").getAsJsonObject().has("layer" + layer)) continue;
                elements.add(FilledCrateModel.make2dElement(layer, 3.0f, 4.0f, 11.0f, 12.0f, 0.002f));
                ResourceLocation contentsTexture = ResourceLocation.m_135820_((String)GsonHelper.m_13906_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"textures"), (String)("layer" + layer)));
                Material contentsMaterial = new Material(TextureAtlas.f_118259_, contentsTexture);
                textureMap.put((CallSite)((Object)("layer" + layer)), Either.left((Object)contentsMaterial));
                materials.add(contentsMaterial);
            }
            BlockModel contents = new BlockModel(FILLED_CRATE_LOCATION, elements, textureMap, Boolean.valueOf(false), BlockModel.GuiLight.FRONT, ItemTransforms.f_111786_, List.of());
            materials.trimToSize();
            return new FilledCrateModel(contents);
        }
    }

    private static class Baked
    implements BakedModel {
        private final ItemTransforms transforms;
        private final TextureAtlasSprite particle;
        private final List<BakedQuad> quads;

        private Baked(BakedModel bakedContents, List<BakedQuad> baseQuads, ItemTransforms transforms) {
            RandomSource random = RandomSource.m_216327_();
            List contentsQuads = bakedContents.m_213637_(null, null, random);
            this.quads = new ArrayList<BakedQuad>(baseQuads.size() + contentsQuads.size());
            this.quads.addAll(baseQuads);
            this.quads.addAll(contentsQuads);
            this.transforms = transforms;
            this.particle = bakedContents.m_6160_();
        }

        public List<BakedQuad> m_213637_(@Nullable BlockState state, @Nullable Direction cullFace, RandomSource rand) {
            return this.quads;
        }

        public boolean m_7541_() {
            return false;
        }

        public boolean m_7539_() {
            return false;
        }

        public boolean m_7547_() {
            return false;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.particle;
        }

        public ItemOverrides m_7343_() {
            return ItemOverrides.f_111734_;
        }

        public ItemTransforms m_7442_() {
            return this.transforms;
        }
    }
}

