/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic.crops;

import forestry.core.utils.BlockUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.farming.logic.crops.Crop;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CropDestroy
extends Crop {
    protected final BlockState blockState;
    @Nullable
    protected final BlockState replantState;
    protected final ItemStack germling;

    public CropDestroy(Level world, BlockState blockState, BlockPos position, @Nullable BlockState replantState) {
        this(world, blockState, position, replantState, ItemStack.f_41583_);
    }

    public CropDestroy(Level world, BlockState blockState, BlockPos position, @Nullable BlockState replantState, ItemStack germling) {
        super(world, position);
        this.blockState = blockState;
        this.replantState = replantState;
        this.germling = germling;
    }

    @Override
    protected boolean isCrop(Level world, BlockPos pos) {
        return world.m_8055_(pos) == this.blockState;
    }

    @Override
    protected List<ItemStack> harvestBlock(Level level, BlockPos pos) {
        List harvested = Block.m_49869_((BlockState)this.blockState, (ServerLevel)((ServerLevel)level), (BlockPos)pos, (BlockEntity)level.m_7702_(pos));
        if (!(harvested instanceof ObjectArrayList)) {
            harvested = ObjectArrayList.wrap((Object[])((ItemStack[])harvested.toArray(ItemStack[]::new)));
        }
        boolean removedSeed = this.germling.m_41619_();
        Iterator dropIterator = harvested.iterator();
        while (dropIterator.hasNext()) {
            ItemStack next = (ItemStack)dropIterator.next();
            if (removedSeed || !ItemStackUtil.isIdenticalItem(next, this.germling)) continue;
            next.m_41774_(1);
            if (next.m_41619_()) {
                dropIterator.remove();
            }
            removedSeed = true;
        }
        if (this.replantState != null) {
            BlockUtil.sendDestroyEffects(level, pos, this.blockState);
            level.m_7731_(pos, this.replantState, 2);
        } else {
            level.m_46961_(pos, false);
        }
        return harvested;
    }

    public String toString() {
        return String.format("CropDestroy [ position: [ %s ]; block: %s ]", this.position, this.blockState);
    }
}

