/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.network.packets;

import forestry.api.modules.IForestryPacketServer;
import forestry.core.network.PacketIdServer;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.NetworkUtil;
import forestry.factory.network.packets.PacketRecipeTransferUpdate;
import forestry.factory.tiles.TileCarpenter;
import forestry.factory.tiles.TileFabricator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;

public record PacketRecipeTransferRequest(BlockPos pos, NonNullList<ItemStack> craftingInventory) implements IForestryPacketServer
{
    public static void handle(PacketRecipeTransferRequest msg, ServerPlayer player) {
        BlockPos pos = msg.pos();
        NonNullList<ItemStack> craftingInventory = msg.craftingInventory();
        BlockEntity tile = TileUtil.getTile((BlockGetter)player.m_9236_(), pos);
        if (tile instanceof TileCarpenter) {
            TileCarpenter carpenter = (TileCarpenter)tile;
            int index = 0;
            for (ItemStack stack : craftingInventory) {
                carpenter.getCraftingInventory().m_6836_(index, stack);
                ++index;
            }
            NetworkUtil.sendNetworkPacket(new PacketRecipeTransferUpdate(carpenter.m_58899_(), craftingInventory), pos, player.m_9236_());
        } else if (tile instanceof TileFabricator) {
            TileFabricator fabricator = (TileFabricator)tile;
            int index = 0;
            for (ItemStack stack : craftingInventory) {
                fabricator.getCraftingInventory().m_6836_(index, stack);
                ++index;
            }
            NetworkUtil.sendNetworkPacket(new PacketRecipeTransferUpdate(fabricator.m_58899_(), craftingInventory), pos, player.m_9236_());
        }
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        buffer.m_130064_(this.pos);
        NetworkUtil.writeItemStacks(buffer, this.craftingInventory);
    }

    @Override
    public ResourceLocation id() {
        return PacketIdServer.RECIPE_TRANSFER_REQUEST;
    }

    public static PacketRecipeTransferRequest decode(FriendlyByteBuf buffer) {
        return new PacketRecipeTransferRequest(buffer.m_130135_(), NetworkUtil.readItemStacks(buffer));
    }
}

