/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.tiles;

import forestry.core.damage.CoreDamageTypes;
import forestry.core.tiles.TemperatureState;
import forestry.energy.features.EnergyTiles;
import forestry.energy.tiles.EngineBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.Nullable;

public class ClockworkEngineBlockEntity
extends EngineBlockEntity {
    private static final float WIND_EXHAUSTION = 0.05f;
    private static final float WIND_TENSION_BASE = 0.5f;
    private static final int WIND_DELAY = 10;
    private static final int ENGINE_CLOCKWORK_HEAT_MAX = 300000;
    private static final int ENGINE_CLOCKWORK_ENERGY_PER_CYCLE = 2;
    private static final float ENGINE_CLOCKWORK_WIND_MAX = 8.0f;
    private float tension = 0.0f;
    private short delay = 0;

    public ClockworkEngineBlockEntity(BlockPos pos, BlockState state) {
        super(EnergyTiles.CLOCKWORK_ENGINE.tileType(), pos, state, "", 300000, 10000);
    }

    @Override
    public void openGui(ServerPlayer player, InteractionHand hand, BlockPos pos) {
        if (player instanceof FakePlayer) {
            return;
        }
        if (this.tension <= 0.0f) {
            this.tension = 0.5f;
        } else if (this.tension < 8.5f) {
            this.tension += (8.5f - this.tension) / 8.5f * 0.5f;
        } else {
            return;
        }
        player.m_36399_(0.05f);
        if ((double)this.tension > 8.05) {
            player.m_6469_(CoreDamageTypes.source((LevelReader)this.f_58857_, CoreDamageTypes.CLOCKWORK), 6.0f);
        }
        this.tension = Math.min(this.tension, 8.5f);
        this.delay = (short)10;
        this.sendNetworkUpdate();
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.tension = nbt.m_128457_("tension");
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128350_("tension", this.tension);
    }

    @Override
    public boolean isRedstoneActivated() {
        return true;
    }

    @Override
    public void dissipateHeat() {
    }

    @Override
    public void generateHeat() {
    }

    @Override
    public boolean mayBurn() {
        return true;
    }

    @Override
    public void burn() {
        this.heat = (int)(this.tension * 10000.0f);
        if (this.delay > 0) {
            this.delay = (short)(this.delay - 1);
            return;
        }
        if (!this.isBurning()) {
            return;
        }
        this.tension = this.tension > 0.01f ? (this.tension *= 0.9995f) : 0.0f;
        this.energyStorage.generateEnergy(2 * (int)this.tension);
        this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
    }

    @Override
    protected boolean isBurning() {
        return this.tension > 0.0f;
    }

    @Override
    public TemperatureState getTemperatureState() {
        TemperatureState state = TemperatureState.getState(this.heat / 10000, 8.0);
        if (state == TemperatureState.MELTING) {
            state = TemperatureState.OVERHEATING;
        }
        return state;
    }

    @Override
    public float getPistonSpeed() {
        if (this.delay > 0) {
            return 0.0f;
        }
        float fromClockwork = this.tension / 8.0f * 0.08f;
        fromClockwork = (float)Math.round(fromClockwork * 100.0f) / 100.0f;
        return fromClockwork;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return null;
    }
}

