/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.inventory;

import forestry.core.config.Constants;
import forestry.core.inventory.IInventoryAdapter;
import forestry.core.inventory.InventoryPlain;
import forestry.core.network.IStreamable;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.NetworkUtil;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class InventoryAdapter
implements IInventoryAdapter,
IStreamable {
    private final InventoryPlain inventory;
    private boolean allowAutomation = true;
    @Nullable
    private int[] slotMap;

    public InventoryAdapter(int size, String name) {
        this(size, name, 64);
    }

    public InventoryAdapter(int size, String name, int stackLimit) {
        this(new InventoryPlain(size, name, stackLimit));
    }

    public InventoryAdapter(InventoryPlain inventory) {
        this.inventory = inventory;
        this.configureSided();
    }

    public InventoryAdapter disableAutomation() {
        this.allowAutomation = false;
        return this;
    }

    public InventoryAdapter copy() {
        InventoryAdapter copy = new InventoryAdapter(this.inventory.m_6643_(), "TEST_TITLE_PLEASE_IGNORE", this.inventory.m_6893_());
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            if (this.inventory.m_8020_(i).m_41619_()) continue;
            copy.m_6836_(i, this.inventory.m_8020_(i).m_41777_());
        }
        return copy;
    }

    public boolean m_7983_() {
        return this.inventory.m_7983_();
    }

    public int m_6643_() {
        return this.inventory.m_6643_();
    }

    public ItemStack m_8020_(int slotId) {
        return this.inventory.m_8020_(slotId);
    }

    public ItemStack m_7407_(int slotId, int count) {
        return this.inventory.m_7407_(slotId, count);
    }

    public void m_6836_(int slotId, ItemStack itemstack) {
        this.inventory.m_6836_(slotId, itemstack);
    }

    public int m_6893_() {
        return this.inventory.m_6893_();
    }

    public void m_6596_() {
        this.inventory.m_6596_();
    }

    public ItemStack m_8016_(int slotIndex) {
        return this.inventory.m_8016_(slotIndex);
    }

    public boolean m_6542_(Player player) {
        return true;
    }

    public boolean m_7013_(int i, ItemStack itemstack) {
        return true;
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack stack) {
        return true;
    }

    @Override
    public boolean isLocked(int slotIndex) {
        return false;
    }

    public int[] m_7071_(Direction side) {
        if (this.allowAutomation && this.slotMap != null) {
            return this.slotMap;
        }
        return Constants.SLOTS_NONE;
    }

    private void configureSided() {
        int count = this.m_6643_();
        this.slotMap = new int[count];
        for (int i = 0; i < count; ++i) {
            this.slotMap[i] = i;
        }
    }

    public boolean m_7155_(int slot, ItemStack stack, Direction side) {
        return this.m_7013_(slot, stack);
    }

    public boolean m_7157_(int slot, ItemStack stack, Direction side) {
        return false;
    }

    @Override
    public void read(CompoundTag compoundNBT) {
        InventoryUtil.readFromNBT((Container)this, this.inventory.getName(), compoundNBT);
    }

    @Override
    public CompoundTag write(CompoundTag compoundNBT) {
        InventoryUtil.writeToNBT((Container)this, this.inventory.getName(), compoundNBT);
        return compoundNBT;
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        NetworkUtil.writeInventory(data, this.inventory);
    }

    @Override
    public void readData(FriendlyByteBuf data) {
        NetworkUtil.readInventory(data, this.inventory);
    }

    public void m_6211_() {
        this.inventory.m_6211_();
    }
}

