/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.core.circuits.ISocketable;
import forestry.core.gui.ContainerLiquidTanksHelper;
import forestry.core.gui.ContainerSocketedHelper;
import forestry.core.gui.ContainerTile;
import forestry.core.gui.IContainerLiquidTanks;
import forestry.core.gui.IContainerSocketed;
import forestry.core.tiles.ILiquidTankTile;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.IFluidTank;

public abstract class ContainerLiquidTanksSocketed<T extends BlockEntity & ISocketable>
extends ContainerTile<T>
implements IContainerSocketed,
IContainerLiquidTanks {
    private final ContainerSocketedHelper<T> socketedHelper;
    private final ContainerLiquidTanksHelper<T> tanksHelper;

    protected ContainerLiquidTanksSocketed(int windowId, MenuType<?> type, Inventory playerInventory, T tile, int xInv, int yInv) {
        super(windowId, type, playerInventory, tile, xInv, yInv);
        this.socketedHelper = new ContainerSocketedHelper<BlockEntity>(this.tile);
        this.tanksHelper = new ContainerLiquidTanksHelper<BlockEntity>(this.tile);
        if (this.player != null) {
            ((ILiquidTankTile)this.tile).getTankManager().sendAllTanks(this, this.player);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handlePipetteClickClient(int slot, Player player) {
        this.tanksHelper.handlePipetteClickClient(slot, player);
    }

    @Override
    public void handlePipetteClick(int slot, ServerPlayer player) {
        this.tanksHelper.handlePipetteClick(slot, player);
    }

    @Override
    public void m_38946_() {
        super.m_38946_();
        if (this.player != null) {
            ((ILiquidTankTile)this.tile).getTankManager().broadcastChanges(this, this.player);
        }
    }

    public void m_6877_(Player PlayerEntity) {
        super.m_6877_(PlayerEntity);
        ((ILiquidTankTile)this.tile).getTankManager().onClosed(this);
    }

    @Override
    @Nullable
    public IFluidTank getTank(int slot) {
        return ((ILiquidTankTile)this.tile).getTankManager().getTank(slot);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleChipsetClick(int slot) {
        this.socketedHelper.handleChipsetClick(slot);
    }

    @Override
    public void handleChipsetClickServer(int slot, ServerPlayer player, ItemStack itemstack) {
        this.socketedHelper.handleChipsetClickServer(slot, player, itemstack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handleSolderingIronClick(int slot) {
        this.socketedHelper.handleSolderingIronClick(slot);
    }

    @Override
    public void handleSolderingIronClickServer(int slot, ServerPlayer player, ItemStack itemstack) {
        this.socketedHelper.handleSolderingIronClickServer(slot, player, itemstack);
    }
}

