/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import forestry.api.core.tooltips.ToolTip;
import forestry.core.fluids.ITankUpdateHandler;
import forestry.core.fluids.TankManager;
import forestry.core.network.IStreamable;
import forestry.core.utils.ModUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class StandardTank
extends FluidTank
implements IStreamable {
    private ITankUpdateHandler tankUpdateHandler;
    private int tankIndex;
    private final boolean canFill;
    private final boolean canDrain;
    private boolean internalTest;
    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    protected ToolTip toolTip;

    public StandardTank(int capacity, boolean canFill, boolean canDrain) {
        super(capacity);
        this.tankUpdateHandler = tank -> {};
        this.canDrain = canDrain;
        this.canFill = canFill;
    }

    public StandardTank(int capacity) {
        super(capacity);
        this.tankUpdateHandler = tank -> {};
        this.canFill = true;
        this.canDrain = true;
    }

    public void setTankIndex(int index) {
        this.tankIndex = index;
    }

    public void setTankUpdateHandler(TankManager tankUpdateHandler) {
        this.tankUpdateHandler = tankUpdateHandler;
    }

    public int getTankIndex() {
        return this.tankIndex;
    }

    public boolean isEmpty() {
        return this.getFluid().isEmpty() || this.getFluid().getAmount() <= 0;
    }

    public boolean isFull() {
        return !this.getFluid().isEmpty() && this.getFluid().getAmount() == this.getCapacity();
    }

    public int getRemainingSpace() {
        return this.capacity - this.getFluidAmount();
    }

    @Nullable
    public Fluid getFluidType() {
        return !this.getFluid().isEmpty() ? this.getFluid().getFluid() : null;
    }

    public boolean isFluidValid(FluidStack stack) {
        return this.internalTest || this.validator.test(stack);
    }

    public boolean canFill() {
        return this.canFill;
    }

    public boolean canDrain() {
        return this.canDrain;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.canFill() || !this.isFluidValid(resource)) {
            return 0;
        }
        return this.fillInternal(resource, action);
    }

    public int fillInternal(FluidStack resource, IFluidHandler.FluidAction action) {
        this.internalTest = true;
        int filled = super.fill(resource, action);
        if (action == IFluidHandler.FluidAction.EXECUTE && filled > 0) {
            this.tankUpdateHandler.updateTankLevels(this);
        }
        this.internalTest = false;
        return filled;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (!this.canDrain) {
            return FluidStack.EMPTY;
        }
        return this.drainInternal(maxDrain, action);
    }

    @Nonnull
    public FluidStack drainInternal(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack drained = super.drain(maxDrain, action);
        if (action == IFluidHandler.FluidAction.EXECUTE && !drained.isEmpty() && drained.getAmount() > 0) {
            this.tankUpdateHandler.updateTankLevels(this);
        }
        return drained;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!this.canDrain) {
            return FluidStack.EMPTY;
        }
        return this.drainInternal(resource, action);
    }

    @Nonnull
    public FluidStack drainInternal(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack drained = super.drain(resource, action);
        if (action == IFluidHandler.FluidAction.EXECUTE && !drained.isEmpty() && drained.getAmount() > 0) {
            this.tankUpdateHandler.updateTankLevels(this);
        }
        return drained;
    }

    public String toString() {
        return String.format("Tank: %s, %d/%d", !this.fluid.isEmpty() ? ModUtil.getRegistryName(this.fluid.getFluid()) : "Empty", this.getFluidAmount(), this.getCapacity());
    }

    protected boolean hasFluid() {
        FluidStack fluid = this.getFluid();
        return !fluid.isEmpty() && fluid.getAmount() > 0 && fluid.getFluid() != Fluids.f_76191_;
    }

    @Override
    public void writeData(FriendlyByteBuf data) {
        data.writeFluidStack(this.fluid);
    }

    @Override
    public void readData(FriendlyByteBuf data) {
        this.fluid = data.readFluidStack();
    }

    @OnlyIn(value=Dist.CLIENT)
    public ToolTip getToolTip() {
        if (this.toolTip == null) {
            this.toolTip = new TankToolTip(this);
        }
        return this.toolTip;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void refreshTooltip() {
        ToolTip toolTip = this.getToolTip();
        toolTip.clear();
        int amount = 0;
        FluidStack fluidStack = this.getFluid();
        if (!fluidStack.isEmpty()) {
            Fluid fluidType = fluidStack.getFluid();
            FluidType attributes = fluidType.getFluidType();
            Rarity rarity = attributes.getRarity();
            if (rarity == null) {
                rarity = Rarity.COMMON;
            }
            toolTip.add(fluidStack.getDisplayName(), rarity.f_43022_);
            amount = this.getFluid().getAmount();
        }
        MutableComponent liquidAmount = Component.m_237110_((String)"for.gui.tooltip.liquid.amount", (Object[])new Object[]{amount, this.getCapacity()});
        toolTip.add((Component)liquidAmount);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class TankToolTip
    extends ToolTip {
        private final StandardTank standardTank;

        public TankToolTip(StandardTank standardTank) {
            this.standardTank = standardTank;
        }

        @Override
        public void refresh() {
            this.standardTank.refreshTooltip();
        }
    }
}

