/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import forestry.api.core.tooltips.ToolTip;
import forestry.core.fluids.StandardTank;
import forestry.core.utils.ModUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.registries.ForgeRegistries;

public class FilteredTank
extends StandardTank {
    private Supplier<Set<ResourceLocation>> filters = Suppliers.ofInstance(Set.of());

    public FilteredTank(int capacity) {
        super(capacity);
        this.setValidator(this::fluidMatchesFilter);
    }

    public FilteredTank(int capacity, boolean canFill, boolean canDrain) {
        super(capacity, canFill, canDrain);
        this.setValidator(this::fluidMatchesFilter);
    }

    public FilteredTank setFilter(Supplier<Set<ResourceLocation>> filters) {
        this.filters = (Supplier)Preconditions.checkNotNull(filters);
        return this;
    }

    public FilteredTank setFilters(Collection<Fluid> filters) {
        HashSet<ResourceLocation> set = new HashSet<ResourceLocation>();
        this.filters = () -> set;
        for (Fluid fluid : filters) {
            set.add(ModUtil.getRegistryName(fluid));
        }
        return this;
    }

    private boolean fluidMatchesFilter(FluidStack resource) {
        return resource.getFluid() != Fluids.f_76191_ && this.filters.get().contains(ModUtil.getRegistryName(resource.getFluid()));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    protected void refreshTooltip() {
        if (this.hasFluid()) {
            super.refreshTooltip();
            return;
        }
        ToolTip toolTip = this.getToolTip();
        toolTip.clear();
        Set<ResourceLocation> filters = this.filters.get();
        if (Screen.m_96638_() || filters.size() < 5) {
            for (ResourceLocation filterName : filters) {
                Fluid fluidFilter = (Fluid)ForgeRegistries.FLUIDS.getValue(filterName);
                FluidType attributes = fluidFilter.getFluidType();
                Rarity rarity = attributes.getRarity();
                if (rarity == null) {
                    rarity = Rarity.COMMON;
                }
                FluidStack filterFluidStack = new FluidStack(fluidFilter, 1);
                toolTip.add(filterFluidStack.getDisplayName(), rarity.f_43022_);
            }
        } else {
            MutableComponent tmiComponent = Component.m_237113_((String)"<").m_7220_((Component)Component.m_237115_((String)"for.gui.tooltip.tmi")).m_7220_((Component)Component.m_237113_((String)">"));
            toolTip.add((Component)tmiComponent, ChatFormatting.ITALIC);
        }
        toolTip.add((Component)Component.m_237110_((String)"for.gui.tooltip.liquid.amount", (Object[])new Object[]{this.getFluidAmount(), this.getCapacity()}));
    }
}

