/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.data.builder;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import forestry.api.core.Product;
import forestry.core.utils.JsonUtil;
import forestry.factory.features.FactoryRecipeTypes;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class CentrifugeRecipeBuilder {
    private int processingTime;
    private Ingredient input;
    private final ArrayList<Product> outputs = new ArrayList();

    public CentrifugeRecipeBuilder setProcessingTime(int processingTime) {
        this.processingTime = processingTime;
        return this;
    }

    public CentrifugeRecipeBuilder setInput(Ingredient input) {
        this.input = input;
        return this;
    }

    public CentrifugeRecipeBuilder product(float chance, ItemStack stack) {
        this.outputs.add(new Product(stack.m_41720_(), stack.m_41613_(), stack.m_41783_(), chance));
        return this;
    }

    public void build(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        Preconditions.checkState((!this.outputs.isEmpty() ? 1 : 0) != 0, (Object)"Empty centrifuge recipes are not allowed");
        consumer.accept(new Result(id, this.processingTime, this.input, this.outputs));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final int processingTime;
        private final Ingredient input;
        private final ArrayList<Product> outputs;

        public Result(ResourceLocation id, int processingTime, Ingredient input, ArrayList<Product> outputs) {
            this.id = id;
            this.processingTime = processingTime;
            this.input = input;
            this.outputs = outputs;
        }

        public void m_7917_(JsonObject json) {
            json.addProperty("time", (Number)this.processingTime);
            json.add("input", this.input.m_43942_());
            JsonArray products = new JsonArray();
            for (Product product : this.outputs) {
                products.add(JsonUtil.serialize(Product.CODEC, product));
            }
            json.add("products", (JsonElement)products);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return FactoryRecipeTypes.CENTRIFUGE.serializer();
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

