/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.blocks;

import com.mojang.authlib.GameProfile;
import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.core.blocks.BlockForestry;
import forestry.core.multiblock.MultiblockTileEntityForestry;
import forestry.core.tiles.TileUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public abstract class BlockStructure
extends BlockForestry {
    protected long previousMessageTick = 0L;

    protected BlockStructure(BlockBehaviour.Properties properties) {
        super(properties.m_60978_(1.0f));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player playerIn, InteractionHand hand, BlockHitResult hit) {
        String validationError;
        if (playerIn.m_6144_()) {
            return InteractionResult.PASS;
        }
        MultiblockTileEntityForestry part = TileUtil.getTile((BlockGetter)worldIn, pos, MultiblockTileEntityForestry.class);
        if (part == null) {
            return InteractionResult.FAIL;
        }
        IMultiblockController controller = part.getMultiblockLogic().getController();
        ItemStack heldItem = playerIn.m_21120_(hand);
        if (heldItem.m_41619_() && !controller.isAssembled() && (validationError = controller.getLastValidationError()) != null) {
            long tick = worldIn.m_46467_();
            if (tick > this.previousMessageTick + 20L) {
                playerIn.m_213846_((Component)Component.m_237113_((String)validationError));
                this.previousMessageTick = tick;
            }
            return InteractionResult.SUCCESS;
        }
        if (controller == null || !controller.isAssembled()) {
            return InteractionResult.PASS;
        }
        if (!worldIn.f_46443_) {
            part.openGui((ServerPlayer)playerIn, pos);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (world.f_46443_) {
            return;
        }
        if (placer instanceof Player) {
            TileUtil.actOnTile((LevelReader)world, pos, MultiblockTileEntityForestry.class, tile -> {
                Player player = (Player)placer;
                GameProfile gameProfile = player.m_36316_();
                tile.setOwner(gameProfile);
            });
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof IMultiblockComponent.HasInventory) {
            IMultiblockComponent.HasInventory component = (IMultiblockComponent.HasInventory)blockEntity;
            Containers.m_19002_((Level)level, (BlockPos)pos, (Container)component.getInternalInventory());
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }
}

