/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.items;

import forestry.api.arboriculture.genetics.IFruit;
import forestry.api.arboriculture.genetics.ITree;
import forestry.api.client.IForestryClientApi;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.alleles.TreeChromosomes;
import forestry.arboriculture.blocks.BlockDecorativeLeaves;
import forestry.arboriculture.blocks.ForestryLeafType;
import forestry.arboriculture.items.ItemBlockLeaves;
import forestry.core.items.ItemBlockForestry;
import forestry.core.items.definitions.IColoredItem;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemBlockDecorativeLeaves
extends ItemBlockForestry<BlockDecorativeLeaves>
implements IColoredItem {
    public ItemBlockDecorativeLeaves(BlockDecorativeLeaves block) {
        super(block, new Item.Properties());
    }

    public Component m_7626_(ItemStack itemStack) {
        BlockDecorativeLeaves block = (BlockDecorativeLeaves)this.m_40614_();
        ForestryLeafType treeDefinition = block.getType();
        return ItemBlockLeaves.getDisplayName(treeDefinition.getIndividual().getSpecies());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getColorFromItemStack(ItemStack itemStack, int renderPass) {
        BlockDecorativeLeaves block = (BlockDecorativeLeaves)this.m_40614_();
        ForestryLeafType leafType = block.getType();
        ITree individual = leafType.getIndividual();
        IGenome genome = individual.getGenome();
        if (renderPass == 2) {
            IFruit fruitProvider = genome.getActiveValue(TreeChromosomes.FRUIT);
            return fruitProvider.getDecorativeColor();
        }
        return IForestryClientApi.INSTANCE.getTreeManager().getTint(individual.getSpecies()).get(null, null);
    }
}

