/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.arboriculture.blocks.ForestryPodType;
import forestry.arboriculture.tiles.TileFruitPod;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.BlockUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;

public class BlockFruitPod
extends CocoaBlock
implements EntityBlock {
    private final ForestryPodType podType;

    public BlockFruitPod(ForestryPodType podType) {
        super(BlockBehaviour.Properties.m_284310_().m_60977_().m_60913_(0.2f, 3.0f).m_60918_(SoundType.f_56736_));
        this.podType = podType;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        TileFruitPod tile = TileUtil.getTile(level, pos, TileFruitPod.class);
        if (tile == null) {
            return ItemStack.f_41583_;
        }
        return tile.getPickBlock();
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            BlockFruitPod.m_49950_((BlockState)state, (Level)level, (BlockPos)pos);
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
            return;
        }
        TileFruitPod tile = TileUtil.getTile((BlockGetter)level, pos, TileFruitPod.class);
        if (tile == null) {
            return;
        }
        tile.onBlockTick(rand);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder context) {
        BlockPos pos = BlockUtil.getPos(context);
        Object object = context.m_287258_().m_7702_(pos);
        if (object instanceof TileFruitPod) {
            TileFruitPod pod = (TileFruitPod)object;
            return pod.getDrops();
        }
        object = context.m_287159_(LootContextParams.f_81462_);
        if (object instanceof TileFruitPod) {
            TileFruitPod pod = (TileFruitPod)object;
            return pod.getDrops();
        }
        return List.of();
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)f_54117_);
        return BlockUtil.isValidPodLocation(level, pos, facing, this.podType.getFruit().getLogTag());
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileFruitPod(pos, state);
    }

    public boolean m_7370_(LevelReader level, BlockPos pos, BlockState state, boolean isClient) {
        TileFruitPod podTile = TileUtil.getTile((BlockGetter)level, pos, TileFruitPod.class);
        return podTile != null && podTile.canMature();
    }

    public void m_214148_(ServerLevel level, RandomSource rand, BlockPos pos, BlockState state) {
        TileFruitPod podTile = TileUtil.getTile((BlockGetter)level, pos, TileFruitPod.class);
        if (podTile != null) {
            podTile.addRipeness(0.5f);
        }
    }
}

