/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.tiles;

import com.google.common.base.Predicate;
import com.mojang.authlib.GameProfile;
import forestry.api.IForestryApi;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.ForestryBeeSpecies;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.apiculture.genetics.IBeeSpecies;
import forestry.api.apiculture.genetics.IBeeSpeciesType;
import forestry.api.apiculture.hives.IHiveTile;
import forestry.api.core.HumidityType;
import forestry.api.core.IErrorLogic;
import forestry.api.core.ISpectacleBlock;
import forestry.api.core.TemperatureType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.api.util.TickHelper;
import forestry.apiculture.ModuleApiculture;
import forestry.apiculture.WorldgenBeekeepingLogic;
import forestry.apiculture.blocks.BlockBeeHive;
import forestry.apiculture.features.ApicultureTiles;
import forestry.apiculture.genetics.effects.ThrottledBeeEffect;
import forestry.apiculture.tiles.HiveBeeHousingInventory;
import forestry.core.damage.CoreDamageTypes;
import forestry.core.inventory.InventoryAdapter;
import forestry.core.network.packets.PacketActiveUpdate;
import forestry.core.tiles.IActivatable;
import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.SpeciesUtil;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;

public class TileHive
extends BlockEntity
implements IHiveTile,
IActivatable,
IBeeHousing,
ISpectacleBlock {
    private final InventoryAdapter contained = new InventoryAdapter(2, "Contained");
    private final HiveBeeHousingInventory inventory;
    private final WorldgenBeekeepingLogic beeLogic;
    private final IErrorLogic errorLogic;
    private final Predicate<LivingEntity> beeTargetPredicate;
    private final TickHelper tickHelper = new TickHelper(0);
    @Nullable
    private IBee containedBee = null;
    private boolean active = false;
    private boolean angry = false;
    private int calmTime;

    public TileHive(BlockEntityType<? extends TileHive> tileType, BlockPos pos, BlockState state) {
        super(tileType, pos, state);
        this.inventory = new HiveBeeHousingInventory(this);
        this.beeLogic = new WorldgenBeekeepingLogic(this);
        this.errorLogic = IForestryApi.INSTANCE.getErrorManager().createErrorLogic();
        this.beeTargetPredicate = new BeeTargetPredicate(this);
    }

    @ApiStatus.Internal
    public TileHive(BlockPos pos, BlockState state) {
        this(ApicultureTiles.HIVE.tileType(), pos, state);
    }

    public void tick(Level level) {
        this.tickHelper.onTick();
        if (level.f_46443_) {
            if (this.active && this.tickHelper.updateOnInterval(4) && this.beeLogic.canDoBeeFX()) {
                this.beeLogic.doBeeFX();
            }
        } else {
            boolean canWork = this.beeLogic.canWork();
            if (this.tickHelper.updateOnInterval(this.angry ? 10 : 200)) {
                if (this.calmTime == 0) {
                    if (canWork) {
                        AABB boundingBox;
                        List entities;
                        if (this.angry && ModuleApiculture.hiveDamageOnAttack && (level.m_6106_().m_5472_() != Difficulty.PEACEFUL || ModuleApiculture.hivesDamageOnPeaceful) && !(entities = level.m_6443_(LivingEntity.class, boundingBox = ThrottledBeeEffect.getBounding(this, this.getContainedBee().getGenome()), this.beeTargetPredicate)).isEmpty()) {
                            Collections.shuffle(entities);
                            LivingEntity entity = (LivingEntity)entities.get(0);
                            if (!(!(entity instanceof Player) && ModuleApiculture.hivesDamageOnlyPlayers || entity.m_20069_() && !ModuleApiculture.hivesDamageUnderwater)) {
                                TileHive.attack(entity, 2);
                            }
                        }
                        this.beeLogic.doWork();
                    }
                } else {
                    --this.calmTime;
                }
            }
            this.setActive(this.calmTime == 0);
        }
    }

    public IBee getContainedBee() {
        if (this.containedBee == null) {
            IIndividual iIndividual;
            ItemStack containedBee = this.contained.m_8020_(0);
            if (!containedBee.m_41619_() && (iIndividual = IIndividualHandlerItem.getIndividual(containedBee)) instanceof IBee) {
                IBee bee;
                this.containedBee = bee = (IBee)iIndividual;
                return this.containedBee;
            }
            IBeeSpecies primarySpecies = (IBeeSpecies)((IBeeSpeciesType)SpeciesUtil.BEE_TYPE.get()).getSpeciesSafe(((BlockBeeHive)this.m_58900_().m_60734_()).getSpeciesId());
            if (primarySpecies != null) {
                this.containedBee = (IBee)primarySpecies.createIndividual();
                return this.containedBee;
            }
            this.containedBee = (IBee)SpeciesUtil.getBeeSpecies(ForestryBeeSpecies.FOREST).createIndividual();
            return this.containedBee;
        }
        return this.containedBee;
    }

    public void setContained(List<ItemStack> bees) {
        for (ItemStack itemstack : bees) {
            InventoryUtil.addStack((Container)this.contained, itemstack, true);
        }
    }

    public void m_142466_(CompoundTag compoundNBT) {
        super.m_142466_(compoundNBT);
        this.contained.read(compoundNBT);
        this.beeLogic.read(compoundNBT);
    }

    public void m_183515_(CompoundTag compoundNBT) {
        super.m_183515_(compoundNBT);
        this.contained.write(compoundNBT);
        this.beeLogic.write(compoundNBT);
    }

    @Override
    public void calmBees() {
        this.calmTime = 5;
        this.angry = false;
        this.setActive(false);
    }

    @Override
    public boolean isAngry() {
        return this.angry;
    }

    @Override
    public void onAttack(Level world, BlockPos pos, Player player) {
        if (this.calmTime == 0) {
            this.angry = true;
        }
    }

    @Override
    public void onBroken(Level world, BlockPos pos, Player player, boolean canHarvest) {
        if (this.calmTime == 0) {
            TileHive.attack((LivingEntity)player, 10);
        }
        if (canHarvest) {
            for (ItemStack beeStack : InventoryUtil.getStacks((Container)this.contained)) {
                if (beeStack == null) continue;
                ItemStackUtil.dropItemStackAsEntity(beeStack, world, pos);
            }
        }
    }

    private static void attack(LivingEntity entity, int maxDamage) {
        Level level = entity.m_9236_();
        double attackAmount = level.f_46441_.m_188500_() / 2.0 + 0.5;
        int damage = (int)(attackAmount * (double)maxDamage);
        if (damage > 0) {
            int count = BeeManager.armorApiaristHelper.wearsItems(entity, null, true);
            if (level.f_46441_.m_188503_(4) >= count) {
                entity.m_6469_(CoreDamageTypes.source((LevelReader)level, CoreDamageTypes.HIVE), (float)damage);
            }
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (!this.f_58857_.f_46443_) {
            NetworkUtil.sendNetworkPacket(new PacketActiveUpdate(this), this.f_58858_, this.f_58857_);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbt = super.m_5995_();
        nbt.m_128379_("active", this.calmTime == 0);
        this.beeLogic.write(nbt);
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.setActive(tag.m_128471_("active"));
        this.beeLogic.read(tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        CompoundTag nbt = pkt.m_131708_();
        this.handleUpdateTag(nbt);
    }

    @Override
    public Iterable<IBeeModifier> getBeeModifiers() {
        return List.of();
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return List.of();
    }

    @Override
    public IBeeHousingInventory getBeeInventory() {
        return this.inventory;
    }

    @Override
    public IBeekeepingLogic getBeekeepingLogic() {
        return this.beeLogic;
    }

    @Override
    public TemperatureType temperature() {
        return IForestryApi.INSTANCE.getClimateManager().getTemperature(this.getBiome());
    }

    @Override
    public HumidityType humidity() {
        return IForestryApi.INSTANCE.getClimateManager().getHumidity(this.getBiome());
    }

    @Override
    public int getBlockLightValue() {
        return this.f_58857_.m_46461_() ? 15 : 0;
    }

    @Override
    public boolean canBlockSeeTheSky() {
        return true;
    }

    @Override
    public boolean isRaining() {
        return this.f_58857_.m_46758_(this.f_58858_.m_7494_());
    }

    @Override
    @Nullable
    public Level getWorldObj() {
        return this.f_58857_;
    }

    @Override
    public Holder<Biome> getBiome() {
        return this.f_58857_.m_204166_(this.f_58858_);
    }

    @Override
    @Nullable
    public GameProfile getOwner() {
        return null;
    }

    @Override
    public Vec3 getBeeFXCoordinates() {
        BlockPos pos = this.f_58858_;
        return new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.25, (double)pos.m_123343_() + 0.5);
    }

    @Override
    public IErrorLogic getErrorLogic() {
        return this.errorLogic;
    }

    @Override
    public BlockPos getCoordinates() {
        return this.f_58858_;
    }

    private record BeeTargetPredicate(IHiveTile hive) implements Predicate<LivingEntity>
    {
        public boolean apply(@Nullable LivingEntity input) {
            if (input != null && input.m_6084_() && !input.m_20145_()) {
                if (input instanceof Player) {
                    return EntitySelector.f_20406_.test(input);
                }
                if (this.hive.isAngry()) {
                    return true;
                }
                if (input instanceof Enemy) {
                    return !(input instanceof EnderMan) && !(input instanceof ZombifiedPiglin);
                }
            }
            return false;
        }
    }
}

