/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.tiles;

import forestry.api.apiculture.IBeeHousingInventory;
import forestry.api.apiculture.IBeeListener;
import forestry.api.apiculture.IBeeModifier;
import forestry.api.apiculture.hives.IHiveFrame;
import forestry.apiculture.ApiaryBeeListener;
import forestry.apiculture.ApiaryBeeModifier;
import forestry.apiculture.IApiary;
import forestry.apiculture.features.ApicultureTiles;
import forestry.apiculture.gui.ContainerBeeHousing;
import forestry.apiculture.gui.GuiBeeHousing;
import forestry.apiculture.inventory.IApiaryInventory;
import forestry.apiculture.inventory.InventoryApiary;
import forestry.apiculture.tiles.TileBeeHousingBase;
import forestry.core.utils.NetworkUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkHooks;

public class TileApiary
extends TileBeeHousingBase
implements IApiary {
    private final IBeeModifier beeModifier = new ApiaryBeeModifier();
    private final IBeeListener beeListener = new ApiaryBeeListener(this);
    private final InventoryApiary inventory = new InventoryApiary();

    public TileApiary(BlockPos pos, BlockState state) {
        super(ApicultureTiles.APIARY.tileType(), pos, state, "apiary");
        this.setInternalInventory(this.inventory);
    }

    @Override
    public IBeeHousingInventory getBeeInventory() {
        return this.inventory;
    }

    @Override
    public IApiaryInventory getApiaryInventory() {
        return this.inventory;
    }

    public Collection<IBeeModifier> getBeeModifiers() {
        ArrayList<IBeeModifier> beeModifiers = new ArrayList<IBeeModifier>();
        beeModifiers.add(this.beeModifier);
        for (Tuple<IHiveFrame, ItemStack> frame : this.inventory.getFrames()) {
            IHiveFrame hiveFrame = (IHiveFrame)frame.m_14418_();
            ItemStack stack = (ItemStack)frame.m_14419_();
            IBeeModifier beeModifier = hiveFrame.getBeeModifier(stack);
            beeModifiers.add(beeModifier);
        }
        return beeModifiers;
    }

    @Override
    public Iterable<IBeeListener> getBeeListeners() {
        return Collections.singleton(this.beeListener);
    }

    public AbstractContainerMenu m_7208_(int windowId, Inventory inv, Player player) {
        return new ContainerBeeHousing(windowId, player.m_150109_(), this, true, GuiBeeHousing.Icon.APIARY);
    }

    @Override
    public void openGui(ServerPlayer player, InteractionHand hand, BlockPos pos) {
        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)this, buffer -> {
            buffer.m_130064_(pos);
            buffer.writeBoolean(true);
            NetworkUtil.writeEnum(buffer, GuiBeeHousing.Icon.APIARY);
        });
    }
}

