/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.inventory;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.apiculture.hives.IHiveFrame;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.capability.IIndividualHandlerItem;
import forestry.apiculture.InventoryBeeHousing;
import forestry.apiculture.inventory.IApiaryInventory;
import forestry.core.utils.SlotUtil;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class InventoryApiary
extends InventoryBeeHousing
implements IApiaryInventory {
    public static final int SLOT_FRAMES_1 = 9;
    public static final int SLOT_FRAMES_COUNT = 3;

    public InventoryApiary() {
        super(12);
    }

    @Override
    public boolean canSlotAccept(int slotIndex, ItemStack stack) {
        if (SlotUtil.isSlotInRange(slotIndex, 9, 3)) {
            return stack.m_41720_() instanceof IHiveFrame && this.m_8020_(slotIndex).m_41619_();
        }
        return super.canSlotAccept(slotIndex, stack);
    }

    @Override
    public boolean m_7013_(int slotIndex, ItemStack itemStack) {
        return !SlotUtil.isSlotInRange(slotIndex, 9, 3) && super.m_7013_(slotIndex, itemStack);
    }

    public Collection<Tuple<IHiveFrame, ItemStack>> getFrames() {
        ArrayList<Tuple<IHiveFrame, ItemStack>> hiveFrames = new ArrayList<Tuple<IHiveFrame, ItemStack>>(3);
        for (int i = 9; i < 12; ++i) {
            ItemStack stackInSlot = this.m_8020_(i);
            Item itemInSlot = stackInSlot.m_41720_();
            if (!(itemInSlot instanceof IHiveFrame)) continue;
            IHiveFrame frame = (IHiveFrame)itemInSlot;
            hiveFrames.add((Tuple<IHiveFrame, ItemStack>)new Tuple((Object)frame, (Object)stackInSlot.m_41777_()));
        }
        return hiveFrames;
    }

    @Override
    public void wearOutFrames(IBeeHousing beeHousing, int amount) {
        int wear = amount;
        for (int i = 9; i < 12; ++i) {
            ItemStack hiveFrameStack = this.m_8020_(i);
            Item hiveFrameItem = hiveFrameStack.m_41720_();
            if (!(hiveFrameItem instanceof IHiveFrame)) continue;
            IHiveFrame hiveFrame = (IHiveFrame)hiveFrameItem;
            IIndividual queen = IIndividualHandlerItem.getIndividual(this.getQueen());
            if (queen == null) continue;
            ItemStack usedFrame = hiveFrame.frameUsed(beeHousing, hiveFrameStack, (IBee)queen, wear);
            this.m_6836_(i, usedFrame);
        }
    }
}

