/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import com.google.common.base.Preconditions;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeJubilance;
import forestry.api.apiculture.genetics.IBee;
import forestry.api.apiculture.genetics.IBeeSpecies;
import forestry.api.apiculture.genetics.IBeeSpeciesType;
import forestry.api.core.HumidityType;
import forestry.api.core.IProduct;
import forestry.api.core.TemperatureType;
import forestry.api.genetics.ClimateHelper;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.alleles.BeeChromosomes;
import forestry.api.genetics.alleles.ForestryAlleles;
import forestry.api.genetics.alleles.IValueAllele;
import forestry.api.plugin.IBeeSpeciesBuilder;
import forestry.apiculture.genetics.Bee;
import forestry.core.genetics.Species;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Rarity;

public class BeeSpecies
extends Species<IBeeSpeciesType, IBee>
implements IBeeSpecies {
    private final List<IProduct> products;
    private final List<IProduct> specialties;
    private final TemperatureType temperature;
    private final HumidityType humidity;
    private final IBeeJubilance jubilance;
    private final int body;
    private final int outline;
    private final int stripes;

    public BeeSpecies(ResourceLocation id, IBeeSpeciesType speciesType, IGenome defaultGenome, IBeeSpeciesBuilder builder) {
        super(id, speciesType, defaultGenome, builder);
        this.products = builder.buildProducts();
        this.specialties = builder.buildSpecialties();
        this.temperature = builder.getTemperature();
        this.humidity = builder.getHumidity();
        this.jubilance = builder.getJubilance();
        this.body = builder.getBody();
        this.outline = builder.getOutline();
        this.stripes = builder.getStripes();
    }

    @Override
    public List<IProduct> getProducts() {
        return this.products;
    }

    @Override
    public List<IProduct> getSpecialties() {
        return this.specialties;
    }

    @Override
    public TemperatureType getTemperature() {
        return this.temperature;
    }

    @Override
    public HumidityType getHumidity() {
        return this.humidity;
    }

    @Override
    public boolean isJubilant(IGenome genome, IBeeHousing housing) {
        return this.jubilance.isJubilant(this, genome, housing);
    }

    @Override
    public IBee createIndividual(IGenome genome) {
        Preconditions.checkArgument((genome.getKaryotype() == this.getKaryotype() ? 1 : 0) != 0);
        return new Bee(genome);
    }

    @Override
    public int getBody() {
        return this.body;
    }

    @Override
    public int getStripes() {
        return this.stripes;
    }

    @Override
    public int getOutline() {
        return this.outline;
    }

    @Override
    public int getEscritoireColor() {
        return this.escritoireColor == -1 ? this.outline : this.escritoireColor;
    }

    @Override
    public void addTooltip(IBee individual, List<Component> tooltip) {
        if (!individual.isAnalyzed()) {
            BeeSpecies.addUnknownGenomeTooltip(tooltip);
            return;
        }
        IGenome genome = individual.getGenome();
        this.addHybridTooltip(tooltip, genome, BeeChromosomes.SPECIES, "for.bees.hybrid");
        int generation = individual.getGeneration();
        if (generation > 0) {
            Rarity rarity = generation >= 1000 ? Rarity.EPIC : (generation >= 100 ? Rarity.RARE : (generation >= 10 ? Rarity.UNCOMMON : Rarity.COMMON));
            tooltip.add((Component)Component.m_237110_((String)"for.gui.beealyzer.generations", (Object[])new Object[]{generation}).m_130938_(rarity.getStyleModifier()));
        }
        tooltip.add((Component)genome.getActiveName(BeeChromosomes.LIFESPAN).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"for.gui.life")).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)genome.getActiveName(BeeChromosomes.SPEED).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"for.gui.worker")).m_130940_(ChatFormatting.GRAY));
        MutableComponent tempToleranceAllele = genome.getActiveName(BeeChromosomes.TEMPERATURE_TOLERANCE);
        MutableComponent humidToleranceAllele = genome.getActiveName(BeeChromosomes.HUMIDITY_TOLERANCE);
        IBeeSpecies active = genome.getActiveValue(BeeChromosomes.SPECIES);
        tooltip.add((Component)Component.m_237113_((String)"T: ").m_7220_((Component)ClimateHelper.toDisplay(active.getTemperature())).m_130946_(" / ").m_7220_((Component)tempToleranceAllele).m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)Component.m_237113_((String)"H: ").m_7220_((Component)ClimateHelper.toDisplay(active.getHumidity())).m_130946_(" / ").m_7220_((Component)humidToleranceAllele).m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)genome.getActiveName(BeeChromosomes.FLOWER_TYPE).m_130940_(ChatFormatting.GRAY));
        IValueAllele activityAllele = (IValueAllele)((Object)genome.getActiveAllele(BeeChromosomes.ACTIVITY));
        if (activityAllele != ForestryAlleles.ACTIVITY_DIURNAL) {
            tooltip.add((Component)BeeChromosomes.ACTIVITY.getDisplayName(activityAllele).m_130940_(ChatFormatting.GOLD));
        }
        if (genome.getActiveValue(BeeChromosomes.TOLERATES_RAIN)) {
            tooltip.add((Component)Component.m_237115_((String)"chromosome.forestry.tolerates_rain.tooltip").m_130940_(ChatFormatting.WHITE));
        }
    }
}

