/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.plugin;

import com.google.common.collect.ImmutableMap;
import forestry.api.core.HumidityType;
import forestry.api.core.TemperatureType;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.api.plugin.IGenomeBuilder;
import forestry.api.plugin.IMutationsRegistration;
import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;

public interface ISpeciesBuilder<T extends ISpeciesType<S, ?>, S extends ISpecies<?>, B extends ISpeciesBuilder<T, S, B>> {
    public B setDominant(boolean var1);

    public B setGenome(Consumer<IGenomeBuilder> var1);

    public B addMutations(Consumer<IMutationsRegistration> var1);

    public B setGlint(boolean var1);

    public B setTemperature(TemperatureType var1);

    public B setHumidity(HumidityType var1);

    public B setComplexity(int var1);

    public B setEscritoireColor(TextColor var1);

    @Deprecated(forRemoval=true)
    default public B setEscritoireColor(Color color) {
        return this.setEscritoireColor(TextColor.m_131266_((int)color.getRGB()));
    }

    public B setSecret(boolean var1);

    public B setAuthority(String var1);

    public B setFactory(ISpeciesFactory<T, S, B> var1);

    public String getGenus();

    public String getSpecies();

    public boolean isDominant();

    public IGenome buildGenome(IGenomeBuilder var1);

    public boolean hasGlint();

    public TemperatureType getTemperature();

    public HumidityType getHumidity();

    public int getComplexity();

    public int getEscritoireColor();

    public boolean isSecret();

    public String getAuthority();

    public ISpeciesFactory<T, S, B> createSpeciesFactory();

    public List<IMutation<S>> buildMutations(ISpeciesType<S, ?> var1, ImmutableMap<ResourceLocation, S> var2);

    @FunctionalInterface
    public static interface ISpeciesFactory<T extends ISpeciesType<S, ?>, S extends ISpecies<?>, B extends ISpeciesBuilder<T, S, B>> {
        public S create(ResourceLocation var1, T var2, IGenome var3, B var4);
    }
}

