/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.plugin;

import com.google.common.collect.ImmutableMap;
import forestry.api.core.HumidityType;
import forestry.api.core.TemperatureType;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.IMutationCondition;
import forestry.api.genetics.ISpecies;
import forestry.api.genetics.ISpeciesType;
import forestry.api.genetics.alleles.IAllele;
import forestry.api.genetics.alleles.IChromosome;
import java.time.Month;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;

public interface IMutationBuilder {
    public IMutationBuilder restrictTemperature(TemperatureType var1);

    public IMutationBuilder restrictTemperature(TemperatureType var1, TemperatureType var2);

    public IMutationBuilder restrictHumidity(HumidityType var1);

    public IMutationBuilder restrictHumidity(HumidityType var1, HumidityType var2);

    public IMutationBuilder restrictBiomeType(TagKey<Biome> var1);

    default public IMutationBuilder restrictDateRange(Month startMonth, int startDay, Month endMonth, int endDay) {
        return this.restrictDateRange(startMonth.getValue(), startDay, endMonth.getValue(), endDay);
    }

    public IMutationBuilder restrictDateRange(int var1, int var2, int var3, int var4);

    public IMutationBuilder requireDay();

    public IMutationBuilder requireNight();

    public IMutationBuilder requireResource(BlockState ... var1);

    public IMutationBuilder addMutationCondition(IMutationCondition var1);

    public <A extends IAllele> IMutationBuilder addSpecialAllele(IChromosome<A> var1, A var2);

    public IMutationBuilder setChance(float var1);

    public <S extends ISpecies<?>> IMutation<S> build(ISpeciesType<S, ?> var1, ImmutableMap<ResourceLocation, S> var2);
}

