/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.world.structures;

import com.google.common.collect.ImmutableList;
import com.kyanite.deeperdarker.DeeperDarker;
import com.kyanite.deeperdarker.world.structures.DDProcessorLists;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class DDPools {
    public static final ResourceKey<StructureTemplatePool> ANCIENT_TEMPLE = DDPools.createKey("ancient_temple/starts");

    public static void bootstrap(BootstapContext<StructureTemplatePool> context) {
        Holder.Reference empty = context.m_255420_(Registries.f_256948_).m_255043_(Pools.f_127186_);
        Holder.Reference degradation = context.m_255420_(Registries.f_257011_).m_255043_(DDProcessorLists.ANCIENT_TEMPLE_DEGRADATION);
        context.m_255272_(ANCIENT_TEMPLE, (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of(DDPools.location("ancient_temple/basement/center_0", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/center_1", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/center_2", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/center_3", (Holder<StructureProcessorList>)degradation), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.m_255272_(DDPools.createKey("ancient_temple/basement/aisles"), (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of(DDPools.location("ancient_temple/basement/aisles/secret_aisle", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/aisles/aisle_0", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/aisles/aisle_1", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/aisles/aisle_2", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/aisles/aisle_3", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/aisles/aisle_4", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/aisles/aisle_5", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/aisles/aisle_6", (Holder<StructureProcessorList>)degradation), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.m_255272_(DDPools.createKey("ancient_temple/basement/corners"), (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of(DDPools.location("ancient_temple/basement/corners/corner_0", (Holder<StructureProcessorList>)degradation), (Object)3), (Object)Pair.of(DDPools.location("ancient_temple/basement/corners/corner_1", (Holder<StructureProcessorList>)degradation), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.m_255272_(DDPools.createKey("ancient_temple/basement/rooms"), (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of(DDPools.location("ancient_temple/basement/rooms/portal_0", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/rooms/portal_1", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/rooms/throne", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/rooms/room_0", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/rooms/room_1", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/rooms/room_2", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/rooms/room_3", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/rooms/room_4", (Holder<StructureProcessorList>)degradation), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.m_255272_(DDPools.createKey("ancient_temple/basement/stairs"), (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of(DDPools.location("ancient_temple/basement/stairs/staircase_0", (Holder<StructureProcessorList>)degradation), (Object)2), (Object)Pair.of(DDPools.location("ancient_temple/basement/stairs/staircase_1", (Holder<StructureProcessorList>)degradation), (Object)2), (Object)Pair.of(DDPools.location("ancient_temple/basement/stairs/staircase_2", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/stairs/staircase_3", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/stairs/staircase_4", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/basement/stairs/staircase_5", (Holder<StructureProcessorList>)degradation), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.m_255272_(DDPools.createKey("ancient_temple/upper"), (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of(DDPools.location("ancient_temple/upper/fountain_0", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/upper/fountain_1", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/upper/fountain_2", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/upper/apex_0", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/upper/apex_1", (Holder<StructureProcessorList>)degradation), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.m_255272_(DDPools.createKey("ancient_temple/upper/corners"), (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of(DDPools.location("ancient_temple/upper/corners/corner_0", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/upper/corners/corner_1", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/upper/corners/corner_2", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/upper/corners/corner_3", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/upper/corners/corner_4", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/upper/corners/corner_5", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/upper/corners/corner_6", (Holder<StructureProcessorList>)degradation), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.m_255272_(DDPools.createKey("ancient_temple/upper/rooms"), (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of(DDPools.location("ancient_temple/upper/rooms/room_0", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/upper/rooms/room_1", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/upper/rooms/room_2", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/upper/rooms/room_3", (Holder<StructureProcessorList>)degradation), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.m_255272_(DDPools.createKey("ancient_temple/mobs"), (Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of(DDPools.location("ancient_temple/mobs/shattered", (Holder<StructureProcessorList>)degradation), (Object)1), (Object)Pair.of(DDPools.location("ancient_temple/mobs/snapper", (Holder<StructureProcessorList>)degradation), (Object)1)), StructureTemplatePool.Projection.RIGID));
    }

    public static Function<StructureTemplatePool.Projection, SinglePoolElement> location(String name, Holder<StructureProcessorList> processor) {
        return projection -> new SinglePoolElement(Either.left((Object)DeeperDarker.rl(name)), (Holder)processor, (StructureTemplatePool.Projection)projection){};
    }

    public static ResourceKey<StructureTemplatePool> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)DeeperDarker.rl(name));
    }
}

