/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.common.fluid;

import cofh.core.CoFHCore;
import cofh.lib.common.fluid.FluidCoFH;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Rarity;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.RegistryObject;

public class ExperienceFluid
extends FluidCoFH {
    private static ExperienceFluid INSTANCE;
    public static final RegistryObject<FluidType> TYPE;

    public static ExperienceFluid create() {
        if (INSTANCE == null) {
            INSTANCE = new ExperienceFluid();
        }
        return INSTANCE;
    }

    protected ExperienceFluid() {
        super(CoFHCore.FLUIDS, "experience");
    }

    @Override
    protected ForgeFlowingFluid.Properties fluidProperties() {
        return new ForgeFlowingFluid.Properties(this.type(), (Supplier)this.stillFluid, (Supplier)this.flowingFluid);
    }

    @Override
    protected Supplier<FluidType> type() {
        return TYPE;
    }

    static {
        TYPE = CoFHCore.FLUID_TYPES.register("experience", () -> new FluidType(FluidType.Properties.create().lightLevel(10).density(250).viscosity(500).rarity(Rarity.UNCOMMON).sound(SoundActions.BUCKET_FILL, SoundEvents.f_11770_).sound(SoundActions.BUCKET_EMPTY, SoundEvents.f_11769_)){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new IClientFluidTypeExtensions(){
                    private static final ResourceLocation STILL = new ResourceLocation("cofh_core:block/fluids/experience_still");
                    private static final ResourceLocation FLOW = new ResourceLocation("cofh_core:block/fluids/experience_flow");

                    public ResourceLocation getStillTexture() {
                        return STILL;
                    }

                    public ResourceLocation getFlowingTexture() {
                        return FLOW;
                    }
                });
            }
        });
    }
}

