/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.botaniaseeds.datagen;

import io.github.chakyl.botaniaseeds.blocks.MysticalFlowerCropBlock;
import io.github.chakyl.botaniaseeds.registry.ModElements;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "botania_seeds", exFileHelper);
    }

    protected void registerStatesAndModels() {
        ModElements.CROP_BLOCKS.getEntries().forEach(entry -> this.customStageBlock((Block)entry.get(), "cross", new ArrayList<Integer>()));
    }

    public void customStageBlock(Block block, String textureKey, List<Integer> suffixes) {
        this.getVariantBuilder(block).forAllStates(state -> {
            int ageSuffix = (Integer)state.m_61143_((Property)MysticalFlowerCropBlock.AGE);
            if (ageSuffix == 5) {
                ageSuffix = 4;
            }
            String stageName = Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)block)).m_135815_() + "_stage";
            stageName = stageName + (suffixes.isEmpty() ? ageSuffix : (Integer)suffixes.get(Math.min(suffixes.size(), ageSuffix)));
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().singleTexture(stageName, this.mcLoc("minecraft:block/cross"), textureKey, new ResourceLocation("botania_seeds", "block/" + stageName))).renderType("cutout")).build();
        });
    }
}

