/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.betterfoliage.model;

import com.eerussianguy.betterfoliage.BFConfig;
import com.eerussianguy.betterfoliage.Helpers;
import com.eerussianguy.betterfoliage.model.BFBakedModel;
import com.eerussianguy.betterfoliage.model.LeavesOrdinalData;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockElementRotation;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.NamedRenderTypeManager;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class LeavesBakedModel
extends BFBakedModel {
    public static List<LeavesBakedModel> INSTANCES = new ArrayList<LeavesBakedModel>();
    private final ResourceLocation leaves;
    private final ResourceLocation fluff;
    private final ResourceLocation overlay;
    private final ResourceLocation modelLocation;
    private final boolean isOverlay;
    private final boolean tintOverlay;
    private final boolean tintLeaves;
    @Nullable
    private TextureAtlasSprite leavesTex;
    @Nullable
    private TextureAtlasSprite fluffTex;
    private final BlockModel blockModel;
    private final BakedModel[] crosses;
    @Nullable
    private BakedModel core;
    @Nullable
    private BakedModel outerCore;

    public LeavesBakedModel(ResourceLocation modelLocation, ResourceLocation leaves, ResourceLocation fluff, ResourceLocation overlay, boolean tintLeaves, boolean tintOverlay) {
        this.crosses = new BakedModel[(int)Math.pow(((Integer)BFConfig.CLIENT.leavesCacheSize.get()).intValue(), 3.0)];
        this.blockModel = new BlockModel(null, new ArrayList(), new HashMap(), Boolean.valueOf(false), BlockModel.GuiLight.FRONT, ItemTransforms.f_111786_, new ArrayList());
        this.modelLocation = modelLocation;
        this.leaves = leaves;
        this.fluff = fluff;
        this.overlay = overlay;
        this.isOverlay = !overlay.equals((Object)Helpers.EMPTY);
        this.tintLeaves = tintLeaves;
        this.tintOverlay = tintOverlay;
        INSTANCES.add(this);
    }

    public void init() {
        this.leavesTex = Helpers.getTexture(this.leaves);
        this.fluffTex = Helpers.getTexture(this.fluff);
        if (this.isOverlay) {
            TextureAtlasSprite overlayTex = Helpers.getTexture(this.overlay);
            this.outerCore = this.buildBlock(overlayTex, this.tintOverlay);
        }
        assert (this.leavesTex != null);
        this.core = this.buildBlock(this.leavesTex, this.tintLeaves);
        this.buildCrosses();
    }

    private void buildCrosses() {
        float[] intervals;
        int ordinal = 0;
        float leavesVariationDistance = ((Double)BFConfig.CLIENT.leavesVariationDistance.get()).floatValue();
        for (float x : intervals = Helpers.intervals((Integer)BFConfig.CLIENT.leavesCacheSize.get(), -leavesVariationDistance, leavesVariationDistance)) {
            for (float y : intervals) {
                for (float z : intervals) {
                    this.buildCross(ordinal, x, y, z);
                    ++ordinal;
                }
            }
        }
    }

    private void buildCross(int ordinal, float x, float y, float z) {
        EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
        mapFacesIn.put(Direction.NORTH, this.tintLeaves ? Helpers.makeTintedFace(Helpers.UV_DEFAULT) : Helpers.makeFace(Helpers.UV_DEFAULT));
        mapFacesIn.put(Direction.SOUTH, this.tintLeaves ? Helpers.makeTintedFace(Helpers.UV_DEFAULT) : Helpers.makeFace(Helpers.UV_DEFAULT));
        Vector3f from = new Vector3f(-8.0f, -8.0f, 8.0f);
        Vector3f to = new Vector3f(24.0f, 24.0f, 8.0f);
        Vector3f moveVec = new Vector3f(x / 2.0f, y / 1.2f, z / 2.0f);
        from.add((Vector3fc)moveVec);
        to.add((Vector3fc)moveVec);
        BlockElement part = new BlockElement(from, to, (Map)mapFacesIn, this.makeRotation(45.0f), false);
        BlockElement partR = new BlockElement(from, to, (Map)mapFacesIn, this.makeRotation(-45.0f), false);
        assert (this.leavesTex != null);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.blockModel, ItemOverrides.f_111734_, false).m_119528_(this.leavesTex);
        Helpers.assembleFaces(builder, part, this.fluffTex, this.modelLocation);
        Helpers.assembleFaces(builder, partR, this.fluffTex, this.modelLocation);
        this.crosses[ordinal] = builder.build(NamedRenderTypeManager.get((ResourceLocation)new ResourceLocation("cutout_mipped")));
    }

    private BlockElementRotation makeRotation(float degrees) {
        return new BlockElementRotation(new Vector3f(0.5f, 0.0f, 0.5f), Direction.Axis.Y, degrees, false);
    }

    private BakedModel buildBlock(TextureAtlasSprite tex, boolean tint) {
        EnumMap mapFacesIn = Maps.newEnumMap(Direction.class);
        for (Direction d : Helpers.DIRECTIONS) {
            mapFacesIn.put(d, tint ? Helpers.makeTintedFace(Helpers.UV_DEFAULT, true) : Helpers.makeFace(Helpers.UV_DEFAULT, true));
        }
        BlockElement part = new BlockElement(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(16.0f, 16.0f, 16.0f), (Map)mapFacesIn, null, true);
        SimpleBakedModel.Builder builder = new SimpleBakedModel.Builder(this.blockModel, ItemOverrides.f_111734_, false).m_119528_(tex);
        for (Map.Entry e : part.f_111310_.entrySet()) {
            Direction d = (Direction)e.getKey();
            builder.m_119530_(d, Helpers.makeBakedQuad(part, (BlockElementFace)e.getValue(), tex, d, BlockModelRotation.X0_Y0, this.modelLocation));
        }
        return builder.build(NamedRenderTypeManager.get((ResourceLocation)new ResourceLocation("cutout_mipped")));
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
        assert (this.core != null);
        List coreQuads = this.core.getQuads(state, side, rand, extraData, renderType);
        if (state != null) {
            LeavesOrdinalData data;
            LeavesOrdinalData leavesOrdinalData = data = extraData.has(LeavesOrdinalData.PROPERTY) ? (LeavesOrdinalData)extraData.get(LeavesOrdinalData.PROPERTY) : new LeavesOrdinalData(BlockPos.f_121853_);
            if (data != null) {
                ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(coreQuads);
                List crossQuads = this.crosses[data.get()].getQuads(state, side, rand, extraData, renderType);
                quads.addAll(crossQuads);
                if (this.isOverlay) {
                    assert (this.outerCore != null);
                    List outQuads = this.outerCore.getQuads(state, side, rand, extraData, renderType);
                    quads.addAll(outQuads);
                }
                return quads;
            }
        }
        return coreQuads;
    }

    @NotNull
    public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData data) {
        return data.derive().with(LeavesOrdinalData.PROPERTY, (Object)new LeavesOrdinalData(pos)).build();
    }

    public TextureAtlasSprite m_6160_() {
        return Objects.requireNonNull(this.leavesTex);
    }

    public BakedModel applyTransform(ItemDisplayContext transformType, PoseStack poseStack, boolean applyLeftHandTransform) {
        Helpers.applyTransform(transformType, poseStack, applyLeftHandTransform);
        return this;
    }
}

