/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.betterfoliage;

import com.eerussianguy.betterfoliage.BFConfig;
import com.eerussianguy.betterfoliage.BetterFoliage;
import com.eerussianguy.betterfoliage.Helpers;
import com.eerussianguy.betterfoliage.ParticleLocation;
import com.eerussianguy.betterfoliage.particle.LeafParticle;
import com.eerussianguy.betterfoliage.particle.SoulParticle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class ForgeEventHandler {
    private static final Map<ParticleLocation, List<TextureAtlasSprite>> SPRITE_CACHE = new HashMap<ParticleLocation, List<TextureAtlasSprite>>();

    public static void init() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(ForgeEventHandler::onClientTick);
    }

    public static void clearCache() {
        SPRITE_CACHE.clear();
    }

    private static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91104_()) {
            return;
        }
        Entity entity = mc.m_91288_();
        if (entity == null) {
            return;
        }
        ClientLevel level = (ClientLevel)entity.m_9236_();
        if (level.m_46467_() % 2L != 0L) {
            return;
        }
        Vec3 ePos = entity.m_20182_();
        Vec3i pos = new Vec3i((int)ePos.f_82479_, (int)ePos.f_82480_, (int)ePos.f_82481_);
        RandomSource rand = level.f_46441_;
        int spawnDistance = (Integer)BFConfig.CLIENT.particleDistance.get();
        AbstractTexture particleTexture = Minecraft.m_91087_().f_90987_.m_118506_(TextureAtlas.f_118260_);
        particleTexture.m_117960_(false, false);
        if (particleTexture instanceof TextureAtlas) {
            TextureAtlas atlas = (TextureAtlas)particleTexture;
            for (int i = 0; i < (Integer)BFConfig.CLIENT.particleAttempts.get(); ++i) {
                TextureSheetParticle particle;
                BlockPos searchPos = new BlockPos(pos.m_7918_(rand.m_188503_(spawnDistance) - rand.m_188503_(spawnDistance), rand.m_188503_(spawnDistance) - 1, rand.m_188503_(spawnDistance) - rand.m_188503_(spawnDistance)));
                BlockState state = level.m_8055_(searchPos);
                if (state.m_204336_(BlockTags.f_13035_) && level.m_46859_(searchPos.m_7495_())) {
                    particle = new LeafParticle(level, (double)searchPos.m_123341_() + 0.5, (double)searchPos.m_123342_() - 1.0, (double)searchPos.m_123343_() + 0.5);
                    if (((Boolean)BFConfig.CLIENT.snowballs.get()).booleanValue() && rand.m_188503_(2) == 0 && level.m_8055_(searchPos.m_7494_()).m_60713_(Blocks.f_50125_)) {
                        Helpers.addParticle(particle, ForgeEventHandler.getTextures(ParticleLocation.SNOWBALL, atlas));
                        continue;
                    }
                    if (!((Boolean)BFConfig.CLIENT.leaves.get()).booleanValue() || BetterFoliage.LEAVES_DISABLED_BY_MOD) continue;
                    Holder biome = level.m_204166_(searchPos);
                    if (biome.m_203656_(BiomeTags.f_207609_)) {
                        Helpers.addTintedParticle(particle, ForgeEventHandler.getTextures(ParticleLocation.LEAF_SPRUCE, atlas), state, level, searchPos);
                        continue;
                    }
                    if (biome.m_203656_(BiomeTags.f_207610_)) {
                        Helpers.addTintedParticle(particle, ForgeEventHandler.getTextures(ParticleLocation.LEAF_JUNGLE, atlas), state, level, searchPos);
                        continue;
                    }
                    Helpers.addTintedParticle(particle, ForgeEventHandler.getTextures(ParticleLocation.LEAF, atlas), state, level, searchPos);
                    continue;
                }
                if (!((Boolean)BFConfig.CLIENT.souls.get()).booleanValue() || !state.m_60713_(Blocks.f_50135_) && !state.m_60713_(Blocks.f_50136_) || !level.m_46859_(searchPos.m_7494_())) continue;
                particle = new SoulParticle(level, (double)searchPos.m_123341_() + 0.5, (double)searchPos.m_123342_() + 1.0, (double)searchPos.m_123343_() + 0.5);
                Helpers.addParticle(particle, ForgeEventHandler.getTextures(ParticleLocation.SOUL, atlas));
                ForgeEventHandler.getTextures(ParticleLocation.SOUL_TRAIL, atlas);
            }
        }
    }

    public static List<TextureAtlasSprite> getTextures(ParticleLocation location, @Nullable TextureAtlas atlas) {
        if (atlas == null) {
            return SPRITE_CACHE.get((Object)location);
        }
        return SPRITE_CACHE.computeIfAbsent(location, s -> location.getResourceLocations().stream().map(arg_0 -> ((TextureAtlas)atlas).m_118316_(arg_0)).toList());
    }
}

