/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.inventories.InternalInventory;
import appeng.api.upgrades.IUpgradeInventory;
import appeng.api.upgrades.IUpgradeableObject;
import appeng.api.util.AEColor;
import appeng.api.util.IConfigurableObject;
import appeng.core.AELog;
import appeng.core.localization.GuiText;
import appeng.core.localization.InGameTooltip;
import appeng.core.localization.PlayerMessages;
import appeng.core.localization.Tooltips;
import appeng.helpers.IConfigInvHost;
import appeng.helpers.IPriorityHost;
import appeng.items.AEBaseItem;
import appeng.items.contents.NetworkToolMenuHost;
import appeng.items.tools.NetworkToolItem;
import appeng.items.tools.SettingsCategory;
import appeng.util.InteractionUtil;
import appeng.util.Platform;
import appeng.util.inv.PlayerInternalInventory;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class MemoryCardItem
extends AEBaseItem
implements IMemoryCard,
DyeableLeatherItem {
    private static final int DEFAULT_BASE_COLOR = 0xDDDDDD;
    private static final AEColor[] DEFAULT_COLOR_CODE = new AEColor[]{AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT, AEColor.TRANSPARENT};

    public MemoryCardItem(Item.Properties properties) {
        super(properties);
    }

    public static Set<SettingsCategory> exportGenericSettings(Object exportFrom, CompoundTag output) {
        EnumSet<SettingsCategory> exported = EnumSet.noneOf(SettingsCategory.class);
        if (exportFrom instanceof IUpgradeableObject) {
            IUpgradeableObject upgradeableObject = (IUpgradeableObject)exportFrom;
            MemoryCardItem.storeUpgrades(upgradeableObject, output);
            exported.add(SettingsCategory.UPGRADES);
        }
        if (exportFrom instanceof IConfigurableObject) {
            IConfigurableObject configurableObject = (IConfigurableObject)exportFrom;
            configurableObject.getConfigManager().writeToNBT(output);
            exported.add(SettingsCategory.SETTINGS);
        }
        if (exportFrom instanceof IPriorityHost) {
            IPriorityHost pHost = (IPriorityHost)exportFrom;
            output.m_128405_("priority", pHost.getPriority());
            exported.add(SettingsCategory.PRIORITY);
        }
        if (exportFrom instanceof IConfigInvHost) {
            IConfigInvHost configInvHost = (IConfigInvHost)exportFrom;
            configInvHost.getConfig().writeToChildTag(output, "config");
            exported.add(SettingsCategory.CONFIG_INV);
        }
        return exported;
    }

    public static Set<SettingsCategory> importGenericSettings(Object importTo, CompoundTag input, @Nullable Player player) {
        IConfigurableObject configurableObject;
        IUpgradeableObject upgradeableObject;
        EnumSet<SettingsCategory> imported = EnumSet.noneOf(SettingsCategory.class);
        if (player != null && importTo instanceof IUpgradeableObject && MemoryCardItem.restoreUpgrades(player, input, upgradeableObject = (IUpgradeableObject)importTo)) {
            imported.add(SettingsCategory.UPGRADES);
        }
        if (importTo instanceof IConfigurableObject && (configurableObject = (IConfigurableObject)importTo).getConfigManager().readFromNBT(input)) {
            imported.add(SettingsCategory.SETTINGS);
        }
        if (importTo instanceof IPriorityHost) {
            IPriorityHost pHost = (IPriorityHost)importTo;
            if (input.m_128425_("priority", 3)) {
                pHost.setPriority(input.m_128451_("priority"));
                imported.add(SettingsCategory.PRIORITY);
            }
        }
        if (importTo instanceof IConfigInvHost) {
            IConfigInvHost configInvHost = (IConfigInvHost)importTo;
            if (input.m_128441_("config")) {
                configInvHost.getConfig().readFromChildTag(input, "config");
                imported.add(SettingsCategory.CONFIG_INV);
            }
        }
        return imported;
    }

    public static void importGenericSettingsAndNotify(Object importTo, CompoundTag input, @Nullable Player player) {
        Set<SettingsCategory> imported = MemoryCardItem.importGenericSettings(importTo, input, player);
        if (player != null && !player.m_20193_().m_5776_()) {
            if (imported.isEmpty()) {
                player.m_5661_((Component)PlayerMessages.InvalidMachine.text(), true);
            } else {
                Component restored = Tooltips.conjunction(imported.stream().map(SettingsCategory::getLabel).toList());
                player.m_5661_((Component)PlayerMessages.InvalidMachinePartiallyRestored.text(restored), true);
            }
        }
    }

    private static void storeUpgrades(IUpgradeableObject upgradeableObject, CompoundTag output) {
        CompoundTag desiredUpgradesTag = new CompoundTag();
        for (ItemStack upgrade : upgradeableObject.getUpgrades()) {
            ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)upgrade.m_41720_());
            if (itemId.equals((Object)BuiltInRegistries.f_257033_.m_122315_())) {
                AELog.warn("Cannot save unregistered upgrade to memory card %s", upgrade.m_41720_());
                continue;
            }
            String key = itemId.toString();
            desiredUpgradesTag.m_128405_(key, desiredUpgradesTag.m_128451_(key) + upgrade.m_41613_());
        }
        output.m_128365_("upgrades", (Tag)desiredUpgradesTag);
    }

    private static boolean restoreUpgrades(Player player, CompoundTag input, IUpgradeableObject upgradeableObject) {
        if (!input.m_128425_("upgrades", 10)) {
            return false;
        }
        CompoundTag desiredUpgradesTag = input.m_128469_("upgrades");
        IdentityHashMap<Item, Integer> desiredUpgrades = new IdentityHashMap<Item, Integer>();
        for (String itemIdStr : desiredUpgradesTag.m_128431_()) {
            ResourceLocation itemId;
            try {
                itemId = new ResourceLocation(itemIdStr);
            }
            catch (ResourceLocationException e) {
                AELog.warn("Memory card contains invalid item id %s", itemIdStr);
                continue;
            }
            Item item = BuiltInRegistries.f_257033_.m_6612_(itemId).orElse(null);
            if (item == null) {
                AELog.warn("Memory card contains unknown item id %s", itemId);
                continue;
            }
            int desiredCount = desiredUpgradesTag.m_128451_(itemIdStr);
            if (desiredCount <= 0) continue;
            desiredUpgrades.put(item, desiredCount);
        }
        IUpgradeInventory upgrades = upgradeableObject.getUpgrades();
        if (player.m_150110_().f_35937_) {
            for (int i = 0; i < upgrades.size(); ++i) {
                upgrades.setItemDirect(i, ItemStack.f_41583_);
            }
            for (Map.Entry entry : desiredUpgrades.entrySet()) {
                upgrades.addItems(new ItemStack((ItemLike)entry.getKey(), ((Integer)entry.getValue()).intValue()));
            }
            return true;
        }
        ArrayList<InternalInventory> upgradeSources = new ArrayList<InternalInventory>();
        upgradeSources.add(new PlayerInternalInventory(player.m_150109_()));
        NetworkToolMenuHost networkTool = NetworkToolItem.findNetworkToolInv(player);
        if (networkTool != null) {
            upgradeSources.add(networkTool.getInventory());
        }
        for (int i = 0; i < upgrades.size(); ++i) {
            ItemStack current = upgrades.getStackInSlot(i);
            if (current.m_41619_()) continue;
            Integer desiredCount = desiredUpgrades.getOrDefault(current.m_41720_(), 0);
            int totalInstalled = upgradeableObject.getInstalledUpgrades((ItemLike)current.m_41720_());
            int toRemove = totalInstalled - desiredCount;
            if (toRemove <= 0) continue;
            ItemStack removed = upgrades.extractItem(i, toRemove, false);
            for (InternalInventory upgradeSource : upgradeSources) {
                if (removed.m_41619_()) continue;
                removed = upgradeSource.addItems(removed);
            }
            if (removed.m_41619_()) continue;
            player.m_36176_(removed, false);
        }
        for (Map.Entry entry : desiredUpgrades.entrySet()) {
            int missingAmount = (Integer)entry.getValue() - upgradeableObject.getInstalledUpgrades((ItemLike)entry.getKey());
            if (missingAmount <= 0) continue;
            ItemStack potential = new ItemStack((ItemLike)entry.getKey(), missingAmount);
            ItemStack overflow = upgrades.addItems(potential, true);
            if (!overflow.m_41619_()) {
                missingAmount -= overflow.m_41613_();
            }
            for (InternalInventory upgradeSource : upgradeSources) {
                ItemStack cards = upgradeSource.removeItems(missingAmount, potential, null);
                if (!cards.m_41619_()) {
                    overflow = upgrades.addItems(cards);
                    if (!overflow.m_41619_()) {
                        player.m_150109_().m_150079_(overflow);
                    }
                    missingAmount -= cards.m_41613_();
                }
                if (missingAmount > 0) continue;
                break;
            }
            if (missingAmount <= 0 || player.m_9236_().m_5776_()) continue;
            player.m_5661_((Component)PlayerMessages.MissingUpgrades.text(((Item)entry.getKey()).m_41466_(), missingAmount), true);
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> lines, TooltipFlag advancedTooltips) {
        String firstLineKey = this.getFirstValidTranslationKey(this.getSettingsName(stack) + ".name", this.getSettingsName(stack));
        lines.add((Component)Tooltips.of((Component)Component.m_237115_((String)firstLineKey)));
        CompoundTag data = this.getData(stack);
        if (data.m_128441_("tooltip")) {
            String tooltipKey = this.getFirstValidTranslationKey(data.m_128461_("tooltip") + ".name", data.m_128461_("tooltip"));
            lines.add((Component)Tooltips.of((Component)Component.m_237115_((String)tooltipKey)));
        }
        if (data.m_128441_("p2pFreq")) {
            short freq = data.m_128448_("p2pFreq");
            MutableComponent freqTooltip = Platform.p2p().toColoredHexString(freq).m_130940_(ChatFormatting.BOLD);
            lines.add((Component)Tooltips.of((Component)Component.m_237110_((String)InGameTooltip.P2PFrequency.getTranslationKey(), (Object[])new Object[]{freqTooltip})));
        }
    }

    private String getFirstValidTranslationKey(String ... name) {
        for (String n3 : name) {
            if (!I18n.m_118936_((String)n3)) continue;
            return n3;
        }
        int n = 0;
        String[] stringArray = name;
        int n2 = stringArray.length;
        if (n < n2) {
            String n3;
            n3 = stringArray[n];
            return n3;
        }
        return "";
    }

    @Override
    public void setMemoryCardContents(ItemStack is, String settingsName, CompoundTag data) {
        CompoundTag c = is.m_41784_();
        c.m_128359_("Config", settingsName);
        c.m_128365_("Data", (Tag)data);
    }

    @Override
    public String getSettingsName(ItemStack is) {
        CompoundTag c = is.m_41784_();
        String name = c.m_128461_("Config");
        return name.isEmpty() ? GuiText.Blank.getTranslationKey() : name;
    }

    @Override
    public CompoundTag getData(ItemStack is) {
        CompoundTag c = is.m_41784_();
        CompoundTag o = c.m_128469_("Data");
        return o.m_6426_();
    }

    @Override
    public AEColor[] getColorCode(ItemStack is) {
        CompoundTag tag = this.getData(is);
        if (tag.m_128425_("colorCode", 11)) {
            int[] frequency = tag.m_128465_("colorCode");
            AEColor[] colorArray = AEColor.values();
            if (frequency.length == 8) {
                return new AEColor[]{colorArray[frequency[0]], colorArray[frequency[1]], colorArray[frequency[2]], colorArray[frequency[3]], colorArray[frequency[4]], colorArray[frequency[5]], colorArray[frequency[6]], colorArray[frequency[7]]};
            }
        }
        return DEFAULT_COLOR_CODE;
    }

    @Override
    public void notifyUser(Player player, MemoryCardMessages msg) {
        if (player.m_20193_().m_5776_()) {
            return;
        }
        switch (msg) {
            case SETTINGS_CLEARED: {
                player.m_5661_((Component)PlayerMessages.SettingCleared.text(), true);
                break;
            }
            case INVALID_MACHINE: {
                player.m_5661_((Component)PlayerMessages.InvalidMachine.text(), true);
                break;
            }
            case SETTINGS_LOADED: {
                player.m_5661_((Component)PlayerMessages.LoadedSettings.text(), true);
                break;
            }
            case SETTINGS_SAVED: {
                player.m_5661_((Component)PlayerMessages.SavedSettings.text(), true);
                break;
            }
            case SETTINGS_RESET: {
                player.m_5661_((Component)PlayerMessages.ResetSettings.text(), true);
                break;
            }
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (InteractionUtil.isInAlternateUseMode(context.m_43723_())) {
            Level level = context.m_43725_();
            if (!level.m_5776_()) {
                this.clearCard(context.m_43723_(), context.m_43725_(), context.m_43724_());
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6225_(context);
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader level, BlockPos pos, Player player) {
        return true;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        if (InteractionUtil.isInAlternateUseMode(player) && !level.f_46443_) {
            this.clearCard(player, level, hand);
        }
        return super.m_7203_(level, player, hand);
    }

    private void clearCard(Player player, Level level, InteractionHand hand) {
        IMemoryCard mem = (IMemoryCard)player.m_21120_(hand).m_41720_();
        mem.notifyUser(player, MemoryCardMessages.SETTINGS_CLEARED);
        player.m_21120_(hand).m_41751_(null);
    }

    public int m_41121_(ItemStack stack) {
        CompoundTag compoundTag = stack.m_41737_("display");
        if (compoundTag != null && compoundTag.m_128425_("color", 99)) {
            return compoundTag.m_128451_("color");
        }
        return 0xDDDDDD;
    }

    public static int getTintColor(ItemStack stack, int tintIndex) {
        Item item;
        if (tintIndex == 1 && (item = stack.m_41720_()) instanceof MemoryCardItem) {
            MemoryCardItem memoryCard = (MemoryCardItem)item;
            return memoryCard.m_41121_(stack);
        }
        return 0xFFFFFF;
    }
}

