/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei.widgets;

import appeng.integration.modules.jei.JEIPlugin;
import appeng.integration.modules.jei.widgets.DrawableWidget;
import appeng.integration.modules.jei.widgets.Label;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public final class WidgetFactory {
    private final IGuiHelper guiHelper;
    private final IDrawableStatic unfilledArrow;
    private final IDrawableStatic filledArrow;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    public WidgetFactory(IJeiHelpers jeiHelpers) {
        this.guiHelper = jeiHelpers.getGuiHelper();
        this.unfilledArrow = this.guiHelper.createDrawable(JEIPlugin.TEXTURE, 0, 17, 24, 17);
        this.filledArrow = this.guiHelper.createDrawable(JEIPlugin.TEXTURE, 0, 0, 24, 17);
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer cookTime) {
                return WidgetFactory.this.guiHelper.createAnimatedDrawable(WidgetFactory.this.filledArrow, cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public DrawableWidget drawable(int x, int y, IDrawable drawable) {
        return new DrawableWidget(drawable, x, y);
    }

    public Label label(float x, float y, Component text) {
        return new Label(x, y, text);
    }

    public DrawableWidget item(int x, int y, ItemStack stack) {
        return new DrawableWidget(this.guiHelper.createDrawableItemStack(stack), x, y);
    }

    public DrawableWidget unfilledArrow(int x, int y) {
        return new DrawableWidget((IDrawable)this.unfilledArrow, x, y);
    }

    public DrawableWidget fillingArrow(int x, int y, int ticks) {
        if (ticks <= 0) {
            return this.unfilledArrow(x, y);
        }
        return new DrawableWidget((IDrawable)this.cachedArrows.getUnchecked((Object)ticks), x, y);
    }
}

