/*
 * Decompiled with CFR 0.152.
 */
package appeng.crafting.pattern;

import appeng.api.stacks.AEItemKey;
import appeng.core.AELog;
import appeng.crafting.pattern.AESmithingTablePattern;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.crafting.pattern.SmithingTablePatternEncoding;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class SmithingTablePatternItem
extends EncodedPatternItem {
    public SmithingTablePatternItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    @Nullable
    public AESmithingTablePattern decode(ItemStack stack, Level level, boolean tryRecovery) {
        CompoundTag tag;
        if (stack.m_41720_() != this || !stack.m_41782_() || level == null) {
            return null;
        }
        AESmithingTablePattern result = this.decode(AEItemKey.of(stack), level);
        if (tryRecovery && result == null && this.attemptRecovery(tag = stack.m_41784_(), level)) {
            result = this.decode(stack, level, false);
        }
        return result;
    }

    @Override
    public AESmithingTablePattern decode(AEItemKey what, Level level) {
        if (what == null || !what.hasTag()) {
            return null;
        }
        try {
            return new AESmithingTablePattern(what, level);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ItemStack encode(SmithingRecipe recipe, AEItemKey template, AEItemKey base, AEItemKey addition, AEItemKey out, boolean allowSubstitutes) {
        ItemStack stack = new ItemStack((ItemLike)this);
        SmithingTablePatternEncoding.encode(stack.m_41784_(), recipe, template, base, addition, out, allowSubstitutes);
        return stack;
    }

    private boolean attemptRecovery(CompoundTag tag, Level level) {
        RecipeManager recipeManager = level.m_7465_();
        AEItemKey template = SmithingTablePatternEncoding.getTemplate(tag);
        AEItemKey base = SmithingTablePatternEncoding.getBase(tag);
        AEItemKey addition = SmithingTablePatternEncoding.getAddition(tag);
        AEItemKey output = SmithingTablePatternEncoding.getOutput(tag);
        if (template == null || base == null || addition == null || output == null) {
            return false;
        }
        ResourceLocation recipeId = SmithingTablePatternEncoding.getRecipeId(tag);
        SimpleContainer testInventory = new SimpleContainer(2);
        testInventory.m_6836_(0, base.toStack());
        testInventory.m_6836_(1, addition.toStack());
        SmithingRecipe recipe = recipeManager.m_44015_(RecipeType.f_44113_, (Container)testInventory, level).orElse(null);
        if (recipe == null) {
            AELog.info("Failed to recover encoded smithing pattern for recipe %s (no recipe for inputs)", recipeId);
            return false;
        }
        if (!AEItemKey.matches(output, recipe.m_8043_(level.m_9598_()))) {
            AELog.info("Failed to recover encoded smithing pattern for recipe %s (output mismatch)", recipeId);
            return false;
        }
        AELog.debug("Re-Encoding pattern from %s -> %s", recipeId, recipe.m_6423_());
        SmithingTablePatternEncoding.encode(tag, recipe, template, base, addition, output, SmithingTablePatternEncoding.canSubstitute(tag));
        return true;
    }
}

