/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.util.AEColor;
import appeng.core.sync.BasePacket;
import appeng.items.tools.powered.ColorApplicatorItem;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ColorApplicatorSelectColorPacket
extends BasePacket {
    @Nullable
    private AEColor color;

    public ColorApplicatorSelectColorPacket(FriendlyByteBuf stream) {
        this.color = stream.readBoolean() ? (AEColor)stream.m_130066_(AEColor.class) : null;
    }

    public ColorApplicatorSelectColorPacket(@Nullable AEColor color) {
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        if (color != null) {
            data.writeBoolean(true);
            data.m_130068_((Enum)color);
        } else {
            data.writeBoolean(false);
        }
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(ServerPlayer player) {
        ColorApplicatorSelectColorPacket.switchColor(player.m_21205_(), this.color);
        ColorApplicatorSelectColorPacket.switchColor(player.m_21206_(), this.color);
    }

    private static void switchColor(ItemStack stack, AEColor color) {
        Item item;
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof ColorApplicatorItem) {
            ColorApplicatorItem colorApplicator = (ColorApplicatorItem)item;
            colorApplicator.setActiveColor(stack, color);
        }
    }
}

