/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.datagen;

import com.smashingmods.alchemistry.datagen.BlockStateGenerator;
import com.smashingmods.alchemistry.datagen.BlockTagGenerator;
import com.smashingmods.alchemistry.datagen.LocalizationGenerator;
import com.smashingmods.alchemistry.datagen.LootTableGenerator;
import com.smashingmods.alchemistry.datagen.RecipeGenerator;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent pEvent) {
        DataGenerator generator = pEvent.getGenerator();
        ExistingFileHelper fileHelper = pEvent.getExistingFileHelper();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = pEvent.getLookupProvider();
        generator.addProvider(pEvent.includeServer(), (DataProvider)new RecipeGenerator(packOutput));
        generator.addProvider(pEvent.includeClient(), (DataProvider)new BlockStateGenerator(packOutput, pEvent.getExistingFileHelper()));
        generator.addProvider(pEvent.includeServer(), (DataProvider)LootTableGenerator.create(packOutput));
        generator.addProvider(pEvent.includeServer(), (DataProvider)new BlockTagGenerator(packOutput, lookupProvider, fileHelper));
        generator.addProvider(pEvent.includeClient(), (DataProvider)new LocalizationGenerator(packOutput));
    }
}

