/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.world.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class LargeRockFeature
extends Feature<Config> {
    public LargeRockFeature(Codec<Config> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<Config> context) {
        BlockPos origin = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        RandomSource rand = context.m_225041_();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        boolean spiky = rand.m_188499_();
        for (int i = -1; i < (spiky ? 4 : 3); ++i) {
            mutable.m_122154_((Vec3i)origin, 0, i, 0);
            LargeRockFeature.setBlock((BlockPos)mutable, context);
        }
        ArrayList<Direction> potentiallyPlaceAbove = new ArrayList<Direction>();
        ArrayList<Direction> placedAbove = new ArrayList<Direction>();
        for (Direction d : Direction.Plane.HORIZONTAL) {
            if ((double)rand.m_188501_() < 0.7) {
                BlockPos imm = origin.m_121945_(d).m_121945_(d.m_122428_());
                LargeRockFeature.setBlock(imm, context);
                for (Direction d1 : Direction.Plane.VERTICAL) {
                    if (!((double)rand.m_188501_() < 0.5)) continue;
                    mutable.m_122159_((Vec3i)imm, d1);
                    LargeRockFeature.setBlock((BlockPos)mutable, context);
                    if (d1 != Direction.UP) continue;
                    potentiallyPlaceAbove.add(d);
                    potentiallyPlaceAbove.add(d.m_122428_());
                }
            }
            for (int i = -1; i < 3; ++i) {
                BlockPos imm1 = origin.m_121945_(d);
                if (i >= 2 && (!potentiallyPlaceAbove.contains(d) || !((double)rand.m_188501_() < 0.7))) continue;
                LargeRockFeature.setBlock(imm1.m_6630_(i), context);
                if (i != 2 || placedAbove.contains(d)) continue;
                placedAbove.add(d);
            }
        }
        int count = placedAbove.size();
        if (count > 1) {
            float chance;
            float f = count == 2 ? 0.3f : (chance = count == 3 ? 0.7f : 1.0f);
            if (count > 3 || rand.m_188501_() < chance) {
                LargeRockFeature.setBlock(origin.m_6630_(spiky ? 4 : 3), context);
            }
        }
        if ((double)rand.m_188501_() < 0.25) {
            Direction d1 = Direction.Plane.HORIZONTAL.m_235690_(rand);
            Direction d2 = rand.m_188499_() ? d1.m_122427_() : d1.m_122428_();
            BlockPos pos = origin.m_5484_(d1, 2).m_121945_(d2);
            BlockPos below = pos.m_7495_();
            BlockPos underBelow = below.m_7495_();
            if (level.m_7433_(pos, state -> state.m_60783_((BlockGetter)level, pos, Direction.UP))) {
                this.placeSecondChunk(pos.m_7494_(), mutable, context);
            } else if (level.m_7433_(below, state -> state.m_60783_((BlockGetter)level, below, Direction.UP))) {
                this.placeSecondChunk(pos, mutable, context);
            } else if (level.m_7433_(underBelow, state -> state.m_60783_((BlockGetter)level, underBelow, Direction.UP))) {
                this.placeSecondChunk(below, mutable, context);
            }
        }
        this.tryPlacePatch(context);
        return true;
    }

    private void placeSecondChunk(BlockPos pos, BlockPos.MutableBlockPos mutable, FeaturePlaceContext<Config> context) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    boolean place;
                    int total = Math.abs(x) + Math.abs(y) + Math.abs(z);
                    boolean bl = context.m_225041_().m_188499_() ? total <= 1 : (place = total <= 2);
                    if (!place) continue;
                    mutable.m_122154_((Vec3i)pos, x, y, z);
                    LargeRockFeature.setBlock((BlockPos)mutable, context);
                }
            }
        }
    }

    private static void setBlock(BlockPos pos, FeaturePlaceContext<Config> context) {
        WorldGenLevel level = context.m_159774_();
        Config config = (Config)context.m_159778_();
        BlockStateProvider provider = config.block();
        RandomSource rand = context.m_225041_();
        Optional<HolderSet<Block>> optional = config.replaceableStates();
        if (level.m_7433_(pos, bs -> bs.m_60795_() || bs.m_247087_() || !bs.m_60838_((BlockGetter)level, pos) && bs.m_60800_((BlockGetter)level, pos) != -1.0f || bs.m_60800_((BlockGetter)level, pos) == 0.0f || optional.isPresent() && bs.m_204341_((HolderSet)optional.get()))) {
            level.m_7731_(pos, provider.m_213972_(rand, pos), 2);
        }
    }

    private boolean tryPlacePatch(FeaturePlaceContext<Config> context) {
        Config config = (Config)context.m_159778_();
        Optional<PatchData> optional = config.patch();
        RandomSource rand = context.m_225041_();
        Optional chance = optional.flatMap(PatchData::chance);
        if (optional.isEmpty() || chance.isPresent() && (Double)chance.get() < (double)rand.m_188501_()) {
            return false;
        }
        PatchData patch = optional.get();
        BlockPos pos = context.m_159777_();
        WorldGenLevel level = context.m_159774_();
        int i = 0;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int j = patch.xzSpread() + 1;
        int k = patch.ySpread() + 1;
        for (int l = 0; l < patch.tries(); ++l) {
            mutable.m_122154_((Vec3i)pos, rand.m_188503_(j) - rand.m_188503_(j), rand.m_188503_(k) - rand.m_188503_(k), rand.m_188503_(j) - rand.m_188503_(j));
            if (!((PlacedFeature)patch.feature().m_203334_()).m_226357_(level, context.m_159775_(), rand, (BlockPos)mutable)) continue;
            ++i;
        }
        return i > 0;
    }

    public record Config(BlockStateProvider block, Optional<HolderSet<Block>> replaceableStates, Optional<PatchData> patch) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(config -> config.group((App)BlockStateProvider.f_68747_.fieldOf("block").forGetter(Config::block), (App)RegistryCodecs.m_206277_((ResourceKey)Registries.f_256747_).optionalFieldOf("replaceable_states").forGetter(Config::replaceableStates), (App)PatchData.CODEC.optionalFieldOf("patch_gen").forGetter(Config::patch)).apply((Applicative)config, Config::new));
    }

    public record PatchData(int tries, int xzSpread, int ySpread, Holder<PlacedFeature> feature, Optional<Double> chance) {
        public static final Codec<PatchData> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ExtraCodecs.f_144629_.fieldOf("patch_tries").forGetter(PatchData::tries), (App)ExtraCodecs.f_144628_.fieldOf("patch_xz_spread").forGetter(PatchData::xzSpread), (App)ExtraCodecs.f_144628_.fieldOf("patch_y_spread").forGetter(PatchData::ySpread), (App)PlacedFeature.f_191773_.fieldOf("patch_feature").forGetter(PatchData::feature), (App)Codec.DOUBLE.optionalFieldOf("spawn_chance").forGetter(PatchData::chance)).apply((Applicative)builder, PatchData::new));
    }
}

