/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.world.density;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Function4;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.function.Function;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.zepalesque.redux.util.math.MathUtil;
import org.jetbrains.annotations.NotNull;

public final class InterpolateFunction
extends Record
implements DensityFunction {
    private final DensityFunction lower;
    private final DensityFunction upper;
    private final int minBlendY;
    private final int maxBlendY;
    private final double minValue;
    private final double maxValue;
    public static final KeyDispatchDataCodec<InterpolateFunction> INTERPOLATE_CODEC = InterpolateFunction.createCodec(InterpolateFunction::create, InterpolateFunction::lower, InterpolateFunction::upper, InterpolateFunction::minBlendY, InterpolateFunction::maxBlendY);

    public InterpolateFunction(DensityFunction lower, DensityFunction upper, int minBlendY, int maxBlendY, double minValue, double maxValue) {
        this.lower = lower;
        this.upper = upper;
        this.minBlendY = minBlendY;
        this.maxBlendY = maxBlendY;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public double m_207386_(DensityFunction.FunctionContext context) {
        return InterpolateFunction.transform(this.lower.m_207386_(context), this.upper.m_207386_(context), this.minBlendY, this.maxBlendY, context.m_207114_());
    }

    public void m_207362_(double @NotNull [] pArray, @NotNull DensityFunction.ContextProvider pContextProvider) {
        pContextProvider.m_207207_(pArray, (DensityFunction)this);
    }

    public InterpolateFunction mapAll(DensityFunction.Visitor pVisitor) {
        return InterpolateFunction.create(this.lower.m_207456_(pVisitor), this.upper.m_207456_(pVisitor), this.minBlendY, this.maxBlendY);
    }

    public static InterpolateFunction create(DensityFunction pLower, DensityFunction pUpper, int minBlendY, int maxBlendY) {
        double minimum = Math.min(pLower.m_207402_(), pUpper.m_207402_());
        double maximum = Math.max(pLower.m_207401_(), pUpper.m_207401_());
        return new InterpolateFunction(pLower, pUpper, minBlendY, maxBlendY, minimum, maximum);
    }

    private static double transform(double funcLower, double funcUpper, int minY, int maxY, int currentY) {
        if (currentY < minY) {
            return funcLower;
        }
        if (currentY > maxY) {
            return funcLower;
        }
        int aboveMin = currentY - minY;
        int range = maxY - minY;
        double progress = (double)aboveMin / (double)range;
        return MathUtil.costrp(progress, funcLower, funcUpper);
    }

    public double m_207402_() {
        return this.minValue;
    }

    public double m_207401_() {
        return this.maxValue;
    }

    public KeyDispatchDataCodec<? extends DensityFunction> m_214023_() {
        return INTERPOLATE_CODEC;
    }

    static <O> KeyDispatchDataCodec<O> createCodec(Function4<DensityFunction, DensityFunction, Integer, Integer, O> creation, Function<O, DensityFunction> lower, Function<O, DensityFunction> upper, Function<O, Integer> min, Function<O, Integer> max) {
        return KeyDispatchDataCodec.m_216238_((MapCodec)RecordCodecBuilder.mapCodec(builder -> builder.group((App)DensityFunction.f_208218_.fieldOf("lower").forGetter(lower), (App)DensityFunction.f_208218_.fieldOf("upper").forGetter(upper), (App)Codec.INT.fieldOf("min").forGetter(min), (App)Codec.INT.fieldOf("max").forGetter(max)).apply((Applicative)builder, creation)));
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{InterpolateFunction.class, "lower;upper;minBlendY;maxBlendY;minValue;maxValue", "lower", "upper", "minBlendY", "maxBlendY", "minValue", "maxValue"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{InterpolateFunction.class, "lower;upper;minBlendY;maxBlendY;minValue;maxValue", "lower", "upper", "minBlendY", "maxBlendY", "minValue", "maxValue"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{InterpolateFunction.class, "lower;upper;minBlendY;maxBlendY;minValue;maxValue", "lower", "upper", "minBlendY", "maxBlendY", "minValue", "maxValue"}, this, o);
    }

    public DensityFunction lower() {
        return this.lower;
    }

    public DensityFunction upper() {
        return this.upper;
    }

    public int minBlendY() {
        return this.minBlendY;
    }

    public int maxBlendY() {
        return this.maxBlendY;
    }
}

