/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.world.biome.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.MobSpawnSettingsBuilder;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.zepalesque.redux.api.condition.AbstractCondition;
import net.zepalesque.redux.world.biome.modifier.ReduxBiomeModifierCodecs;

public record ReduxSpawnsModifier(HolderSet<Biome> biomes, List<MobSpawnSettings.SpawnerData> spawners, AbstractCondition<?> condition, double charge, double energyBudget) implements BiomeModifier
{
    public static final Codec<ReduxSpawnsModifier> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(ReduxSpawnsModifier::biomes), (App)new ExtraCodecs.EitherCodec(MobSpawnSettings.SpawnerData.f_48403_.listOf(), MobSpawnSettings.SpawnerData.f_48403_).xmap(either -> (List)either.map(Function.identity(), List::of), list -> list.size() == 1 ? Either.right((Object)((MobSpawnSettings.SpawnerData)list.get(0))) : Either.left((Object)list)).fieldOf("spawners").forGetter(ReduxSpawnsModifier::spawners), (App)AbstractCondition.CODEC.fieldOf("condition").forGetter(ReduxSpawnsModifier::condition), (App)Codec.DOUBLE.fieldOf("charge").forGetter(ReduxSpawnsModifier::charge), (App)Codec.DOUBLE.fieldOf("energy_budget").forGetter(ReduxSpawnsModifier::energyBudget)).apply((Applicative)builder, ReduxSpawnsModifier::new));

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD && this.biomes.m_203333_(biome) && this.condition.isConditionMet()) {
            MobSpawnSettingsBuilder spawns = builder.getMobSpawnSettings();
            for (MobSpawnSettings.SpawnerData spawner : this.spawners) {
                EntityType type = spawner.f_48404_;
                spawns.m_48376_(type.m_20674_(), spawner);
                spawns.m_48370_(type, this.charge, this.energyBudget);
            }
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)ReduxBiomeModifierCodecs.MOB_SPAWN_CONFIG.get();
    }
}

