/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.util.holder;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.zepalesque.redux.util.holder.RegistryMap;

public class RegistryMapCodec<K, V>
implements Codec<RegistryMap<K, V>> {
    private final Codec<Map<Either<TagKey<K>, ResourceKey<K>>, V>> codec;
    private final ResourceKey<? extends Registry<K>> key;

    RegistryMapCodec(ResourceKey<? extends Registry<K>> registry, Codec<V> valueCodec) {
        Codec eitherCodec = Codec.either((Codec)TagKey.m_203886_(registry), (Codec)ResourceKey.m_195966_(registry));
        this.codec = Codec.unboundedMap((Codec)eitherCodec, valueCodec);
        this.key = registry;
    }

    public <T> DataResult<Pair<RegistryMap<K, V>, T>> decode(DynamicOps<T> ops, T input) {
        if (ops instanceof RegistryOps) {
            RegistryOps regOps = (RegistryOps)ops;
            Optional optional = regOps.m_255056_(this.key);
            if (optional.isEmpty()) {
                return DataResult.error(() -> "Unknown registry: " + this.key);
            }
            Object t = optional.get();
            if (t instanceof HolderLookup.RegistryLookup) {
                HolderLookup.RegistryLookup lookup = (HolderLookup.RegistryLookup)t;
                DataResult mapResult = this.codec.decode(ops, input);
                return mapResult.map(pair -> pair.mapFirst(map -> RegistryMap.createFull(map, lookup)));
            }
        }
        return DataResult.error(() -> "Not a registry ops");
    }

    public <T> DataResult<T> encode(RegistryMap<K, V> input, DynamicOps<T> ops, T prefix) {
        return this.codec.encode(input.encodeMap(), ops, prefix);
    }
}

