/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.recipe.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.api.ItemStackConstructor;
import net.zepalesque.redux.recipe.AbstractStackingRecipe;
import org.slf4j.Logger;

public class StackingRecipeBuilder
implements RecipeBuilder {
    private final Ingredient ingredient;
    private final ItemStackConstructor result;
    private Optional<CompoundTag> extra = Optional.empty();
    private Optional<SoundEvent> sound = Optional.empty();
    private final RecipeSerializer<? extends AbstractStackingRecipe> serializer;

    public StackingRecipeBuilder(Ingredient ingredient, ItemStackConstructor result, RecipeSerializer<? extends AbstractStackingRecipe> serializer) {
        this.ingredient = ingredient;
        this.result = result;
        this.serializer = serializer;
    }

    public static StackingRecipeBuilder recipe(Ingredient ingredient, ItemStackConstructor result, RecipeSerializer<? extends AbstractStackingRecipe> factory) {
        return new StackingRecipeBuilder(ingredient, result, factory);
    }

    public StackingRecipeBuilder withExtra(CompoundTag data) {
        this.extra = Optional.of(data);
        return this;
    }

    public StackingRecipeBuilder withSound(SoundEvent sound) {
        this.sound = Optional.of(sound);
        return this;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public ItemStackConstructor getResultStack() {
        return this.result;
    }

    public RecipeSerializer<? extends AbstractStackingRecipe> getSerializer() {
        return this.serializer;
    }

    public RecipeBuilder m_126145_(@Nullable String groupName) {
        return this;
    }

    public Item m_142372_() {
        return Items.f_41852_;
    }

    public RecipeBuilder m_126132_(String criterionName, CriterionTriggerInstance criterionTrigger) {
        return this;
    }

    public void m_126140_(Consumer<FinishedRecipe> finishedRecipeConsumer, ResourceLocation id) {
        finishedRecipeConsumer.accept(new Result(id, this.ingredient, this.result, this.extra, this.sound, this.serializer));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient ingredient;
        private final ItemStackConstructor result;
        private final Optional<CompoundTag> extra;
        private final Optional<SoundEvent> sound;
        private final RecipeSerializer<? extends AbstractStackingRecipe> serializer;

        public Result(ResourceLocation id, Ingredient ingredient, ItemStackConstructor result, Optional<CompoundTag> extra, Optional<SoundEvent> sound, RecipeSerializer<? extends AbstractStackingRecipe> serializer) {
            this.id = id;
            this.ingredient = ingredient;
            this.result = result;
            this.extra = extra;
            this.sound = sound;
            this.serializer = serializer;
        }

        public void m_7917_(JsonObject json) {
            JsonOps ops = JsonOps.INSTANCE;
            json.add("ingredient", this.ingredient.m_43942_());
            JsonElement object = (JsonElement)ItemStackConstructor.CODEC.encodeStart((DynamicOps)ops, (Object)this.result).result().orElseThrow();
            json.add("result", object);
            this.extra.flatMap(tag -> CompoundTag.f_128325_.encodeStart((DynamicOps)ops, tag).resultOrPartial(arg_0 -> ((Logger)Redux.LOGGER).error(arg_0))).ifPresent(element -> json.add("additional", element));
            this.sound.map(arg_0 -> ((Registry)BuiltInRegistries.f_256894_).m_7981_(arg_0)).ifPresent(loc -> json.addProperty("sound", loc.toString()));
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        @Nullable
        public JsonObject m_5860_() {
            return null;
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

