/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.network;

import com.aetherteam.nitrogen.network.BasePacket;
import java.util.function.Function;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.network.packet.BlightshadeParticlePacket;
import net.zepalesque.redux.network.packet.DoubleJumpPacket;
import net.zepalesque.redux.network.packet.InfuseItemPacket;
import net.zepalesque.redux.network.packet.LoreUnlockPacket;
import net.zepalesque.redux.network.packet.ReduxCockatriceSyncPacket;
import net.zepalesque.redux.network.packet.ReduxPlayerSyncPacket;
import net.zepalesque.redux.network.packet.ShootFireballPacket;
import net.zepalesque.redux.network.packet.SubzeroArrowHitGroundPacket;
import net.zepalesque.redux.network.packet.SubzeroArrowPacket;
import net.zepalesque.redux.network.packet.SyncAetherGrassesPacket;
import net.zepalesque.redux.network.packet.UpdateJumpAbilityPacket;
import net.zepalesque.redux.network.packet.VampireAmuletSyncPacket;

public class ReduxPacketHandler {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)Redux.locate("main"), () -> "1", "1"::equals, "1"::equals);
    private static int index;

    public static synchronized void register() {
        ReduxPacketHandler.register(ReduxCockatriceSyncPacket.class, ReduxCockatriceSyncPacket::decode);
        ReduxPacketHandler.register(DoubleJumpPacket.class, DoubleJumpPacket::decode);
        ReduxPacketHandler.register(ReduxPlayerSyncPacket.class, ReduxPlayerSyncPacket::decode);
        ReduxPacketHandler.register(UpdateJumpAbilityPacket.class, UpdateJumpAbilityPacket::decode);
        ReduxPacketHandler.register(ShootFireballPacket.class, ShootFireballPacket::decode);
        ReduxPacketHandler.register(SubzeroArrowPacket.class, SubzeroArrowPacket::decode);
        ReduxPacketHandler.register(SubzeroArrowHitGroundPacket.class, SubzeroArrowHitGroundPacket::decode);
        ReduxPacketHandler.register(InfuseItemPacket.class, InfuseItemPacket::decode);
        ReduxPacketHandler.register(VampireAmuletSyncPacket.class, VampireAmuletSyncPacket::decode);
        ReduxPacketHandler.register(LoreUnlockPacket.class, LoreUnlockPacket::decode);
        ReduxPacketHandler.register(SyncAetherGrassesPacket.class, SyncAetherGrassesPacket::decode);
        ReduxPacketHandler.register(BlightshadeParticlePacket.class, BlightshadeParticlePacket::decode);
    }

    private static <MSG extends BasePacket> void register(Class<MSG> packet, Function<FriendlyByteBuf, MSG> decoder) {
        INSTANCE.messageBuilder(packet, index++).encoder(BasePacket::encode).decoder(decoder).consumerMainThread(BasePacket::handle).add();
    }

    public static <MSG> void sendToPlayer(MSG message, ServerPlayer player) {
        INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), message);
    }

    public static <MSG> void sendToNear(MSG message, double x, double y, double z, double radius, ResourceKey<Level> dimension) {
        INSTANCE.send(PacketDistributor.NEAR.with(PacketDistributor.TargetPoint.p((double)x, (double)y, (double)z, (double)radius, dimension)), message);
    }

    public static <MSG> void sendToAll(MSG message) {
        INSTANCE.send(PacketDistributor.ALL.noArg(), message);
    }

    public static <MSG> void sendToServer(MSG message) {
        INSTANCE.sendToServer(message);
    }

    public static <MSG> void sendToDimension(MSG message, ResourceKey<Level> dimension) {
        INSTANCE.send(PacketDistributor.DIMENSION.with(() -> dimension), message);
    }
}

