/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.mixin.common.world;

import com.aetherteam.aether.world.configuration.AercloudConfiguration;
import com.aetherteam.aether.world.feature.AercloudFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.zepalesque.redux.mixin.common.world.FeatureMixin;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AercloudFeature.class})
public abstract class AercloudFeatureMixin
extends FeatureMixin<AercloudConfiguration> {
    @Unique
    private static final float DIRECTION_MAX_Y = 0.27f;
    @Unique
    private static final float TILT_RADIANS = 0.3f;
    @Unique
    private static final float DIRECTION_DISPLACEMENT_AMOUNT = 0.5f;
    @Unique
    private static final float RADIUS_XZ_MIN = 1.5f;
    @Unique
    private static final float RADIUS_XZ_MAX = 2.7f;
    @Unique
    private static final float RADIUS_Y_MIN = 1.1f;
    @Unique
    private static final float RADIUS_Y_MAX = 1.5f;
    @Unique
    private static final float Y_FLATTENING_CUTOFF_RATIO = 0.9f;

    @Inject(method={"place"}, at={@At(value="HEAD")}, cancellable=true)
    private void redux$place(FeaturePlaceContext<AercloudConfiguration> context, CallbackInfoReturnable<Boolean> cir) {
        WorldGenLevel level = context.m_159774_();
        RandomSource random = context.m_225041_();
        Vector3f direction = AercloudFeatureMixin.redux$sampleDirection(random, 0.27f, new Vector3f());
        Vector3f binormal = new Vector3f(0.0f, random.m_188499_() ? -1.0f : 1.0f, 0.0f).cross((Vector3fc)direction).normalize();
        Vector3f normal = binormal.cross((Vector3fc)direction, new Vector3f());
        Vector3f tiltedNormal = new Vector3f((Vector3fc)normal).mul(Mth.m_14089_((float)0.3f)).add((Vector3fc)new Vector3f((Vector3fc)binormal).mul(Mth.m_14031_((float)0.3f)));
        Vector3f tiltedBinormal = direction.cross((Vector3fc)tiltedNormal, new Vector3f());
        AercloudConfiguration config = (AercloudConfiguration)context.m_159778_();
        Vector3f blockPosRelative = new Vector3f((Vector3fc)direction).negate().mul((float)config.bounds() / 2.0f);
        BlockState blockState = config.block().m_213972_(random, context.m_159777_());
        Vector3f iterationDisplacement = new Vector3f();
        Vector3f deltaFromCurrentCenter = new Vector3f();
        Vector3f scaledDirection = new Vector3f();
        Vector3f scaledTiltedNormal = new Vector3f();
        Vector3f scaledTiltedBinormal = new Vector3f();
        for (int amount = 0; amount < config.bounds(); ++amount) {
            AercloudFeatureMixin.redux$sampleDirection(random, 1.0f, iterationDisplacement);
            iterationDisplacement.mul(0.5f);
            iterationDisplacement.add((Vector3fc)direction);
            blockPosRelative.add((Vector3fc)iterationDisplacement);
            float radiusXZ = Mth.m_216283_((RandomSource)random, (float)1.5f, (float)2.7f);
            float radiusY = Mth.m_216283_((RandomSource)random, (float)1.1f, (float)1.5f);
            float rangeX = Mth.m_14116_((float)(Mth.m_14207_((float)(direction.x() * radiusXZ)) + Mth.m_14207_((float)(tiltedNormal.x() * radiusY)) + Mth.m_14207_((float)(tiltedBinormal.x() * radiusXZ))));
            float rangeY = Mth.m_14116_((float)(Mth.m_14207_((float)(direction.y() * radiusXZ)) + Mth.m_14207_((float)(tiltedNormal.y() * radiusY)) + Mth.m_14207_((float)(tiltedBinormal.y() * radiusXZ))));
            float rangeZ = Mth.m_14116_((float)(Mth.m_14207_((float)(direction.z() * radiusXZ)) + Mth.m_14207_((float)(tiltedNormal.z() * radiusY)) + Mth.m_14207_((float)(tiltedBinormal.z() * radiusXZ))));
            float rangeYWithCutoff = rangeY * 0.9f;
            direction.mul(1.0f / radiusXZ, scaledDirection);
            tiltedNormal.mul(1.0f / radiusY, scaledTiltedNormal);
            tiltedBinormal.mul(1.0f / radiusXZ, scaledTiltedBinormal);
            for (int dz = Mth.m_14167_((float)(blockPosRelative.z() - rangeZ)); dz <= Mth.m_14143_((float)(blockPosRelative.z() + rangeZ)); ++dz) {
                for (int dy = Mth.m_14167_((float)(blockPosRelative.y() - rangeY)); dy <= Mth.m_14143_((float)(blockPosRelative.y() + rangeYWithCutoff)); ++dy) {
                    for (int dx = Mth.m_14167_((float)(blockPosRelative.x() - rangeX)); dx <= Mth.m_14143_((float)(blockPosRelative.x() + rangeX)); ++dx) {
                        BlockPos newPosition = context.m_159777_().m_7918_(dx, dy, dz);
                        if (!level.m_46859_(newPosition)) continue;
                        deltaFromCurrentCenter.set((float)dx - blockPosRelative.x(), (float)dy - blockPosRelative.y(), (float)dz - blockPosRelative.z());
                        if (!(Mth.m_14207_((float)deltaFromCurrentCenter.dot((Vector3fc)scaledDirection)) + Mth.m_14207_((float)deltaFromCurrentCenter.dot((Vector3fc)scaledTiltedNormal)) + Mth.m_14207_((float)deltaFromCurrentCenter.dot((Vector3fc)scaledTiltedBinormal)) < 1.0f)) continue;
                        this.m_5974_((LevelWriter)level, newPosition, blockState);
                    }
                }
            }
        }
        cir.setReturnValue((Object)true);
    }

    @Unique
    private static Vector3f redux$sampleDirection(RandomSource random, float yRange, Vector3f destination) {
        float thetaXZ = random.m_188501_() * ((float)Math.PI * 2);
        float sinThetaY = Mth.m_216283_((RandomSource)random, (float)(-yRange), (float)yRange);
        float cosThetaY = Mth.m_14116_((float)(1.0f - sinThetaY * sinThetaY));
        destination.set(Mth.m_14031_((float)thetaXZ) * cosThetaY, sinThetaY, Mth.m_14089_((float)thetaXZ) * cosThetaY);
        return destination;
    }
}

