/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.mixin.client.render.model;

import com.aetherteam.aether.client.renderer.entity.model.CockatriceModel;
import com.aetherteam.aether.entity.monster.Cockatrice;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;
import net.zepalesque.redux.capability.cockatrice.CockatriceExtension;
import net.zepalesque.redux.config.ReduxConfig;
import net.zepalesque.redux.config.enums.CockatriceModelType;
import net.zepalesque.redux.mixin.client.render.model.BipedBirdModelMixin;
import net.zepalesque.redux.util.math.MathUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CockatriceModel.class})
public class CockatriceModelMixin
extends BipedBirdModelMixin<Cockatrice> {
    @Unique
    private boolean useNewModel;

    @Inject(method={"setupAnim(Lcom/aetherteam/aether/entity/monster/Cockatrice;FFFFF)V"}, at={@At(value="TAIL")}, remap=false)
    public void setupAnim(Cockatrice cockatrice, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        this.useNewModel = (Boolean)ReduxConfig.CLIENT.cockatrice_model_upgrade.get();
        if (this.useNewModel) {
            this.jaw.f_104203_ = 0.1f;
        }
        float partial = Minecraft.m_91087_().getPartialTick();
        if (ReduxConfig.CLIENT.cockatrice_model_type.get() == CockatriceModelType.refreshed) {
            float progress = cockatrice.isEntityOnGround() ? 0.0f : 1.0f;
            float swingCalc = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            if (CockatriceExtension.get(cockatrice).isPresent()) {
                CockatriceExtension cockatriceAnim = (CockatriceExtension)CockatriceExtension.get(cockatrice).orElseThrow(() -> new IllegalStateException("Could not find CockatriceExtension capability!"));
                progress = Mth.m_14179_((float)partial, (float)cockatriceAnim.getPrevLegAnim(), (float)cockatriceAnim.getLegAnim()) * 0.2f;
            }
            this.rightLeg.f_104203_ = MathUtil.costrp(progress, swingCalc, 0.6f);
            this.leftLeg.f_104203_ = MathUtil.costrp(progress, -swingCalc, 0.6f);
        }
    }

    @Inject(method={"renderToBuffer"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderToBuffer(PoseStack poseStack, VertexConsumer consumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, CallbackInfo ci) {
        if (!this.useNewModel) {
            this.head.m_104301_(poseStack, consumer, packedLight, packedOverlay);
            this.rightTailFeather.m_104301_(poseStack, consumer, packedLight, packedOverlay);
            this.middleTailFeather.m_104301_(poseStack, consumer, packedLight, packedOverlay);
            this.leftTailFeather.m_104301_(poseStack, consumer, packedLight, packedOverlay);
            this.body.m_104301_(poseStack, consumer, packedLight, packedOverlay);
        }
        if (!this.useNewModel || ReduxConfig.CLIENT.cockatrice_model_type.get() == CockatriceModelType.refreshed) {
            this.rightLeg.m_104301_(poseStack, consumer, packedLight, packedOverlay);
            this.leftLeg.m_104301_(poseStack, consumer, packedLight, packedOverlay);
        }
        ci.cancel();
    }
}

