/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.item.tools;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.zepalesque.redux.client.audio.ReduxSoundEvents;
import net.zepalesque.redux.item.util.CustomStackingBehavior;
import org.jetbrains.annotations.Nullable;

public interface VeridiumItem
extends CustomStackingBehavior {
    public static final String NBT_KEY = "infusion_level";
    public static final int DURABILITY_DMG_MULTIPLIER = 4;
    public static final Component HOVER_TOOLTIP = Component.m_237115_((String)"gui.aether_redux.infusion_info");

    public Item getUninfusedItem(ItemStack var1);

    default public ItemStack getUninfusedStack(ItemStack stack) {
        ItemStack i = new ItemStack((ItemLike)this.getUninfusedItem(stack));
        CompoundTag tag = stack.m_41784_().m_6426_();
        tag.m_128473_(NBT_KEY);
        i.m_41751_(tag);
        return i;
    }

    @Override
    @Nullable
    default public ItemStack transformStack(Ingredient ingredient, ItemStack original, RecipeType<?> type, Optional<CompoundTag> additionalData) {
        if (additionalData.isEmpty()) {
            return original;
        }
        CompoundTag additional = additionalData.get();
        byte increase = additional.m_128445_("added_infusion");
        if (increase <= 0) {
            return original;
        }
        byte max = 64;
        CompoundTag tag = original.m_41784_();
        if (tag.m_128445_(NBT_KEY) >= max) {
            return null;
        }
        byte infusion = (byte)Math.min(tag.m_128445_(NBT_KEY) + additional.m_128445_("added_infusion"), max);
        original.m_41700_(NBT_KEY, (Tag)ByteTag.m_128266_((byte)infusion));
        return original;
    }

    @Nullable
    default public ItemStack deplete(ItemStack stack, @Nullable LivingEntity user, int amount) {
        Player p;
        if (user != null && user.m_9236_().m_5776_()) {
            return null;
        }
        if (user instanceof Player && (p = (Player)user).m_7500_()) {
            return null;
        }
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128445_(NBT_KEY) <= amount) {
            return this.getUninfusedStack(stack);
        }
        byte infusion = (byte)(tag.m_128445_(NBT_KEY) - amount);
        stack.m_41700_(NBT_KEY, (Tag)ByteTag.m_128266_((byte)infusion));
        return null;
    }

    default public Optional<Holder<SoundEvent>> getUninfuseSound() {
        return ReduxSoundEvents.INFUSION_EXPIRE.getHolder();
    }

    default public void sendSound(ServerPlayer sp) {
        this.getUninfuseSound().ifPresent(sound -> sp.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(sound, SoundSource.PLAYERS, sp.m_20185_(), sp.m_20186_(), sp.m_20189_(), 0.8f, 0.8f + sp.m_9236_().m_213780_().m_188501_() * 0.4f, sp.m_9236_().m_213780_().m_188505_())));
    }
}

