/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.render.entity.model.entity;

import com.aetherteam.aether_genesis.entity.monster.BattleSentry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.zepalesque.redux.capability.animation.sentry.battle.BattleSentryAnimation;
import net.zepalesque.redux.config.ReduxConfig;
import net.zepalesque.redux.util.math.EasingUtil;
import net.zepalesque.redux.util.math.MathUtil;

public class BattleSentryReduxModel<T extends BattleSentry>
extends EntityModel<T> {
    private final ModelPart body;
    private final ModelPart legFL;
    private final ModelPart legFR;
    private final ModelPart legBL;
    private final ModelPart legBR;

    public BattleSentryReduxModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.legFL = this.body.m_171324_("legFL");
        this.legFR = this.body.m_171324_("legFR");
        this.legBL = this.body.m_171324_("legBL");
        this.legBR = this.body.m_171324_("legBR");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.0f, -4.0f, -6.5f, 12.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)14.0f, (float)0.5f));
        PartDefinition saws = body.m_171599_("saws", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition legFL = body.m_171599_("legFL", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)5.0f, (float)8.0f, (float)-6.5f));
        PartDefinition cube_r1 = legFL.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(22, 26).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition legFR = body.m_171599_("legFR", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-5.0f, (float)8.0f, (float)-6.5f));
        PartDefinition cube_r2 = legFR.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(22, 26).m_171480_().m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition legBL = body.m_171599_("legBL", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)5.0f, (float)8.0f, (float)5.5f));
        PartDefinition cube_r3 = legBL.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(22, 26).m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition legBR = body.m_171599_("legBR", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-5.0f, (float)8.0f, (float)5.5f));
        PartDefinition cube_r4 = legBR.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(22, 26).m_171480_().m_171488_(-1.0f, 0.0f, 0.0f, 2.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        BattleSentryAnimation.get(entity).ifPresent(anim -> {
            float partial = Minecraft.m_91087_().getPartialTick();
            byte wake = anim.getWakeAnim();
            byte prevWake = anim.getPrevWakeAnim();
            float trueWake = Mth.m_14179_((float)partial, (float)prevWake, (float)wake);
            float progressWake = (5.0f - trueWake) / 5.0f;
            this.body.f_104201_ = 14.0f + EasingUtil.Back.inOut(progressWake) * 2.0f;
            byte jump = anim.getJumpAnim();
            int prevJump = jump > 1 && anim.getPrevJumpAnim() == 0 ? 10 : anim.getPrevJumpAnim();
            float trueJump = Mth.m_14179_((float)partial, (float)prevJump, (float)jump);
            float progress = (10.0f - trueJump) / 10.0f;
            if (progress <= 0.3f) {
                this.legFL.f_104203_ = this.legFR.f_104203_ = MathUtil.costrp(1.0f - progressWake, 2.3561945f, EasingUtil.Cubic.inOut(progress / 0.3f) * 75.0f * ((float)Math.PI / 180));
                this.legBR.f_104203_ = MathUtil.costrp(1.0f - progressWake, -2.3561945f, EasingUtil.Cubic.inOut(progress / 0.3f) * 10.0f * ((float)Math.PI / 180));
            } else {
                this.legFL.f_104203_ = this.legFR.f_104203_ = MathUtil.costrp(1.0f - progressWake, 2.3561945f, 1.3089969f - EasingUtil.Cubic.inOut((progress - 0.3f) / 0.7f) * 1.3089969f);
                this.legBR.f_104203_ = MathUtil.costrp(1.0f - progressWake, -2.3561945f, 0.17453292f - EasingUtil.Cubic.inOut((progress - 0.3f) / 0.7f) * 0.17453292f);
            }
            this.legBL.f_104203_ = this.legBR.f_104203_;
        });
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (((Boolean)ReduxConfig.CLIENT.sentry_model_upgrade.get()).booleanValue()) {
            this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }
}

