/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client.render.entity.layer.entity;

import com.aetherteam.aether.client.renderer.entity.model.MimicModel;
import com.aetherteam.aether.entity.monster.dungeon.Mimic;
import com.aetherteam.aether_genesis.entity.GenesisEntityTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Calendar;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.ModList;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.capability.animation.mimic.MimicAnimation;
import net.zepalesque.redux.client.render.entity.model.entity.MimicReduxModel;
import net.zepalesque.redux.config.ReduxConfig;
import net.zepalesque.redux.config.enums.MimicModelType;
import net.zepalesque.redux.mixin.client.render.RenderAccessor;
import net.zepalesque.redux.util.math.EasingUtil;

public class MimicReduxLayer
extends RenderLayer<Mimic, MimicModel> {
    private final MimicReduxModel model;
    private final MobRenderer<Mimic, MimicModel> parentRenderer;
    private boolean isChristmas;
    private static final ResourceLocation REDUX_TEXTURE = new ResourceLocation("aether", "textures/entity/mobs/mimic/normal_redux.png");
    private static final ResourceLocation REDUX_SKYROOT = new ResourceLocation("aether_genesis", "textures/entity/mobs/mimic/skyroot_redux.png");
    private static final ResourceLocation REDUX_XMAS_TEXTURE = new ResourceLocation("aether", "textures/entity/mobs/mimic/christmas_redux.png");
    private static final ResourceLocation REDUX_LOOTR_TEXTURE = new ResourceLocation("aether", "textures/entity/mobs/mimic/lootr_redux.png");

    public MimicReduxLayer(RenderLayerParent<Mimic, MimicModel> pRenderer, MimicReduxModel mimicModel) {
        super(pRenderer);
        MobRenderer rdr;
        this.model = mimicModel;
        this.parentRenderer = pRenderer instanceof MobRenderer ? (rdr = (MobRenderer)pRenderer) : null;
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) == 11 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.isChristmas = true;
        }
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Mimic mimic, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (((MimicModelType)((Object)ReduxConfig.CLIENT.mimic_model_upgrade.get())).shouldUseModern()) {
            this.model.setupAnim(mimic, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            MimicAnimation.get(mimic).ifPresent(anim -> {
                float prevAnim = anim.getPrevOpenAnim() == 0 && anim.getOpenAnim() > 1 ? 10.0f : (float)anim.getPrevOpenAnim();
                float progress = (10.0f - Mth.m_14179_((float)partialTicks, (float)prevAnim, (float)anim.getOpenAnim())) / 10.0f;
                if (anim.getOpenAnim() != 0 && anim.getPrevOpenAnim() != 0) {
                    this.setShadowRadius(EasingUtil.Sinusoidal.inOut(progress) * 0.5f + 0.25f);
                } else {
                    this.setShadowRadius(mimic.f_19797_ <= 1 ? 0.25f : 0.75f);
                }
            });
            if (Minecraft.m_91087_().f_91074_ != null && !mimic.m_20177_((Player)Minecraft.m_91087_().f_91074_)) {
                ResourceLocation tex = this.getTextureLocation(mimic);
                VertexConsumer consumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)tex));
                this.model.m_7695_(poseStack, consumer, packedLight, LivingEntityRenderer.m_115338_((LivingEntity)mimic, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            }
        } else {
            this.setShadowRadius(1.0f);
        }
    }

    private void setShadowRadius(float r) {
        if (this.parentRenderer != null) {
            ((RenderAccessor)this.parentRenderer).setShadowRadius(r);
        }
    }

    @Nonnull
    public ResourceLocation getTextureLocation(@Nonnull Mimic mimic) {
        return ModList.get().isLoaded("lootr") ? REDUX_LOOTR_TEXTURE : (this.isChristmas ? REDUX_XMAS_TEXTURE : (Redux.aetherGenesisCompat() && mimic.m_6095_() == GenesisEntityTypes.SKYROOT_MIMIC.get() ? REDUX_SKYROOT : REDUX_TEXTURE));
    }
}

