/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.client;

import java.util.Optional;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.common.Mod;
import net.orcinus.galosphere.Galosphere;
import net.orcinus.galosphere.init.GItems;
import net.zepalesque.redux.Redux;
import net.zepalesque.redux.api.blockhandler.WoodHandler;
import net.zepalesque.redux.block.ReduxBlocks;
import net.zepalesque.redux.capability.living.VampireAmulet;
import net.zepalesque.redux.config.ReduxConfig;
import net.zepalesque.redux.item.ReduxItems;
import net.zepalesque.redux.item.accessory.VampireAmuletItem;
import net.zepalesque.redux.item.weapons.SubzeroCrossbowItem;

@Mod.EventBusSubscriber(modid="aether_redux", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ReduxClient {
    public static final String LIMB_MOVEMENT = "query.limb_movement";
    public static final String HEAD_X_ROT = "query.head_x_rotation";
    public static final String HEAD_Y_ROT = "query.head_y_rotation";

    public static void registerMolangQueries() {
    }

    public static void fixSignTextures(WoodHandler handler) {
        ResourceLocation texture = Redux.locate("entity/signs/" + handler.woodName);
        Material material = new Material(Sheets.f_110739_, texture);
        Sheets.f_110743_.put(handler.woodType, material);
        ResourceLocation hangingTexture = Redux.locate("entity/signs/hanging/" + handler.woodName);
        Material hangingMaterial = new Material(Sheets.f_110739_, hangingTexture);
        Sheets.f_244291_.put(handler.woodType, hangingMaterial);
    }

    public static void registerItemModelProperties() {
        ItemProperties.register((Item)((Item)ReduxItems.SUBZERO_CROSSBOW.get()), (ResourceLocation)Redux.locate("pull"), (stack, level, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            return SubzeroCrossbowItem.m_40932_(stack) ? 0.0f : (float)(stack.m_41779_() - entity.m_21212_()) / (float)SubzeroCrossbowItem.m_40939_(stack);
        });
        ItemProperties.register((Item)((Item)ReduxItems.SUBZERO_CROSSBOW.get()), (ResourceLocation)Redux.locate("pulling"), (stack, level, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack && !SubzeroCrossbowItem.m_40932_(stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)ReduxItems.SUBZERO_CROSSBOW.get()), (ResourceLocation)Redux.locate("charged"), (stack, level, entity, seed) -> SubzeroCrossbowItem.m_40932_(stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)ReduxItems.SUBZERO_CROSSBOW.get()), (ResourceLocation)Redux.locate("firework"), (stack, level, entity, seed) -> SubzeroCrossbowItem.m_40932_(stack) && SubzeroCrossbowItem.m_40871_((ItemStack)stack, (Item)Items.f_42688_) ? 1.0f : 0.0f);
        if (Redux.galosphereCompat()) {
            ItemProperties.register((Item)((Item)ReduxItems.SUBZERO_CROSSBOW.get()), (ResourceLocation)Galosphere.id((String)"glow_flare"), (stack, world, entity, i) -> entity != null && SubzeroCrossbowItem.m_40932_(stack) && SubzeroCrossbowItem.m_40871_((ItemStack)stack, (Item)((Item)GItems.GLOW_FLARE.get())) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ReduxItems.SUBZERO_CROSSBOW.get()), (ResourceLocation)Galosphere.id((String)"spectre_flare"), (stack, world, entity, i) -> entity != null && SubzeroCrossbowItem.m_40932_(stack) && SubzeroCrossbowItem.m_40871_((ItemStack)stack, (Item)((Item)GItems.SPECTRE_FLARE.get())) ? 1.0f : 0.0f);
        }
        ItemProperties.register((Item)((Item)ReduxItems.VAMPIRE_AMULET.get()), (ResourceLocation)Redux.locate("active"), (stack, level, entity, seed) -> {
            if (entity == null) {
                return 0.0f;
            }
            Optional isActive = VampireAmulet.get(entity).map(VampireAmulet::canUseAbility);
            return VampireAmuletItem.validForActivation(stack) && isActive.isPresent() && (Boolean)isActive.get() != false ? 1.0f : 0.0f;
        });
        ItemProperties.register((Item)((Item)ReduxItems.SPEAR_OF_THE_BLIGHT.get()), (ResourceLocation)Redux.locate("throwing"), (stack, level, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Block)ReduxBlocks.AURUM.get()).m_5456_(), (ResourceLocation)Redux.locate("enchanted"), (stack, world, living, seed) -> (Boolean)ReduxConfig.COMMON.enchanted_gilded_grass.get() != false ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Block)ReduxBlocks.GOLDEN_CLOVER.get()).m_5456_(), (ResourceLocation)Redux.locate("enchanted"), (stack, world, living, seed) -> (Boolean)ReduxConfig.COMMON.enchanted_gilded_grass.get() != false ? 1.0f : 0.0f);
    }
}

