/*
 * Decompiled with CFR 0.152.
 */
package net.zepalesque.redux.capability.cockatrice;

import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.entity.monster.Cockatrice;
import com.aetherteam.aether.item.EquipmentUtil;
import com.aetherteam.nitrogen.capability.INBTSynchable;
import com.aetherteam.nitrogen.network.BasePacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.network.simple.SimpleChannel;
import net.zepalesque.redux.capability.cockatrice.CockatriceExtension;
import net.zepalesque.redux.config.ReduxConfig;
import net.zepalesque.redux.item.ReduxItems;
import net.zepalesque.redux.network.ReduxPacketHandler;
import net.zepalesque.redux.network.packet.ReduxCockatriceSyncPacket;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;

public class CockatriceExtensionCapability
implements CockatriceExtension {
    private final Cockatrice cockatrice;
    private boolean isShooting;
    @Nullable
    private Collection<Entity> nearby = new ArrayList<Entity>();
    private int refreshTime = 0;
    private boolean wasMelee = false;
    private byte targetAnim;
    private byte prevTargetAnim;
    private byte legAnim;
    private byte prevLegAnim;
    private final Map<String, Triple<INBTSynchable.Type, Consumer<Object>, Supplier<Object>>> synchableFunctions = Map.ofEntries(Map.entry("shooting", Triple.of((Object)INBTSynchable.Type.BOOLEAN, obj -> this.setShooting((Boolean)obj), this::isShooting)));

    public CockatriceExtensionCapability(Cockatrice pCockatrice) {
        this.cockatrice = pCockatrice;
    }

    @Override
    public Cockatrice getCockatrice() {
        return this.cockatrice;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("targeting", this.isShooting());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128441_("targeting")) {
            this.setShooting(tag.m_128471_("targeting"));
        }
    }

    @Override
    public void setShooting(boolean shooting) {
        this.isShooting = shooting;
    }

    @Override
    public boolean isShooting() {
        return this.isShooting;
    }

    @Override
    public byte getTargetAnim() {
        return this.targetAnim;
    }

    @Override
    public byte getPrevTargetAnim() {
        return this.prevTargetAnim;
    }

    @Override
    public byte getLegAnim() {
        return this.legAnim;
    }

    @Override
    public byte getPrevLegAnim() {
        return this.prevLegAnim;
    }

    public BasePacket getSyncPacket(String key, INBTSynchable.Type type, Object value) {
        return new ReduxCockatriceSyncPacket(this.getCockatrice().m_19879_(), key, type, value);
    }

    public SimpleChannel getPacketChannel() {
        return ReduxPacketHandler.INSTANCE;
    }

    public Map<String, Triple<INBTSynchable.Type, Consumer<Object>, Supplier<Object>>> getSynchableFunctions() {
        return this.synchableFunctions;
    }

    @Override
    public void tick() {
        this.handleLegAnim();
        this.handleTargetAnim();
        this.handleBurning();
    }

    @Override
    public void handleBurning() {
        if (!this.cockatrice.m_9236_().m_5776_() && this.cockatrice.m_6084_() && this.isSunSensitive() && this.isSunBurnTick()) {
            this.cockatrice.m_20254_(8);
        }
    }

    @Override
    public void handleTargetAnim() {
        if (((Boolean)ReduxConfig.COMMON.improved_cockatrice_behavior.get()).booleanValue()) {
            if (this.getCockatrice().m_9236_().m_5776_()) {
                this.prevTargetAnim = this.targetAnim;
                if (this.isShooting && this.targetAnim < 10) {
                    this.targetAnim = (byte)(this.targetAnim + 1);
                }
                if (!this.isShooting && this.targetAnim > 0) {
                    this.targetAnim = (byte)(this.targetAnim - 1);
                }
            } else {
                boolean shooting;
                int refreshReset = 200;
                if (this.refreshTime <= 0) {
                    this.refreshNearby();
                    this.refreshTime = refreshReset;
                } else {
                    --this.refreshTime;
                }
                if (!this.wasMelee && this.cockatrice.m_5448_() != null && this.refreshTime < refreshReset) {
                    this.refreshNearby();
                }
                boolean hasInebriation = this.getCockatrice().m_5448_() != null && (this.getCockatrice().m_5448_().m_21023_((MobEffect)AetherEffects.INEBRIATION.get()) || EquipmentUtil.hasCurio((LivingEntity)this.cockatrice.m_5448_(), (Item)((Item)ReduxItems.FEATHER_OF_WARDING.get())));
                boolean inGroup = this.nearbyCount() >= 3;
                boolean bl = shooting = !hasInebriation && this.getCockatrice().m_5448_() != null && !inGroup || (Boolean)ReduxConfig.COMMON.improved_cockatrice_behavior.get() == false;
                if (!shooting && this.cockatrice.m_5448_() != null) {
                    this.wasMelee = true;
                } else if (this.cockatrice.m_5448_() == null) {
                    this.wasMelee = false;
                }
                this.setSynched(INBTSynchable.Direction.CLIENT, "shooting", shooting && !this.wasMelee);
            }
        }
    }

    @Override
    public boolean wasMelee() {
        return this.wasMelee;
    }

    @Override
    public void refreshNearby() {
        if (this.cockatrice.m_5448_() != null) {
            Level level = this.cockatrice.m_9236_();
            AABB bounds = this.cockatrice.m_20191_().m_82400_(10.0);
            this.nearby = level.m_6249_((Entity)this.cockatrice, bounds, entity -> entity.m_6095_() == AetherEntityTypes.COCKATRICE.get());
        } else if (this.nearby != null) {
            this.nearby.clear();
        } else {
            this.nearby = new ArrayList<Entity>();
        }
    }

    @Override
    @Nullable
    public Collection<Entity> getNearby() {
        return this.nearby;
    }

    @Override
    public int nearbyCount() {
        return this.getNearby() != null ? this.getNearby().size() : 0;
    }

    @Override
    public void handleLegAnim() {
        if (this.getCockatrice().m_9236_().m_5776_()) {
            this.prevLegAnim = this.legAnim;
            if (!this.cockatrice.isEntityOnGround() && this.legAnim < 5) {
                this.legAnim = (byte)(this.legAnim + 1);
            }
            if (this.cockatrice.isEntityOnGround() && this.legAnim > 0) {
                this.legAnim = (byte)(this.legAnim - 1);
            }
        }
    }

    protected boolean isSunBurnTick() {
        if (this.cockatrice.m_9236_().m_46461_() && !this.cockatrice.m_9236_().f_46443_) {
            boolean flag;
            float f = this.cockatrice.m_213856_();
            BlockPos blockpos = BlockPos.m_274561_((double)this.cockatrice.m_20185_(), (double)this.cockatrice.m_20188_(), (double)this.cockatrice.m_20189_());
            boolean bl = flag = this.cockatrice.m_20071_() || this.cockatrice.f_146808_ || this.cockatrice.f_146809_;
            if (f > 0.5f && this.cockatrice.m_9236_().f_46441_.m_188501_() * 30.0f < (f - 0.4f) * 2.0f && !flag && this.cockatrice.m_9236_().m_45527_(blockpos)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isSunSensitive() {
        return (Boolean)ReduxConfig.COMMON.cockatrice_burn_in_daylight.get();
    }
}

